require 'colorize' # gem install colorize
require 'json'

# The class Toolbox contains all tools needed to treat files before
# use it with SIMCAQ's tools
class Toolbox
  @@checkmark = " \u2713"
  @@dot = "\u26AB "
  def get_file_size(file)
    get_size = "ls -lh #{file}"
    `#{get_size}`.split(' ')[4]
  end

  def convert_encoding(file_in, file_out, encoding_in = 'ISO-8859-14',
                       encoding_out = 'UTF-8')
    cmd = "iconv -f #{encoding_in} #{file_in} -t #{encoding_out} -o #{file_out}"
    print @@dot + 'Convertendo o Encoding do arquivo'.blue.bold
    system(cmd)
    puts @@checkmark.encode('utf-8').green.bold
  end

  def remove_character(file_in, file_out, character = '\r')
    char_name =
      if character == "\r"
        'CRLF'
      else
        (character == "\"") || (character == "\'") ? 'Aspas' : character
      end
    cmd = "tr -d '#{character}' < #{file_in} > #{file_out}"
    print @@dot + "Removendo o #{char_name}".blue.bold
    system(cmd)
    puts @@checkmark.encode('utf-8').green.bold
  end

  def change_float_separator(file)
    cmd = "sed -i -e 's/,/\./g'  #{file}"
    print @@dot + 'Substituindo vírgula por ponto'.blue.bold
    system(cmd)
    puts @@checkmark.encode('utf-8').green.bold
  end

  def clean_directory(files)
    cmd = "rm #{files}"
    print @@dot + 'Limpando o diretório'.blue.bold
    system(cmd)
    puts @@checkmark.encode('utf-8').green.bold
  end

  def rename_file(file_in, file_out)
    cmd = "mv #{file_in} #{file_out}"
    print @@dot + 'Renomeando arquivo '.blue.bold +
         file_in.split('/').last.to_s.yellow.bold+ ' para '.bold.blue +
         file_out.split('/').last.to_s.bold.green
    system(cmd)
    puts @@checkmark.encode('utf-8').green.bold
  end
end

# The class main is used to initialize the software.
class Main
  def initialize
    @tools = Toolbox.new
    @number_of_arguments = ARGV.length
    @arguments = JSON.parse(File.read(ARGV[0]))
    @remove = @arguments['remove']
    @change_float_point = @arguments['change_float_point']
    @change_encoding = @arguments['change_encoding']
    @files = @arguments['files']
    if @change_encoding
      @encoding_in = @arguments['encoding_in']
      @encoding_out = @arguments['encoding_out']
    else
      @encoding_in = nil
      @encoding_out = nil
    end
  end

  def update_file
    @files.each_with_index do |f, i|
      print "\n--- Trabalhando ".light_cyan.bold +
            "no arquivo #{f.split('/').last} ".light_cyan.bold +
            "(#{@tools.get_file_size(f)})".light_magenta.bold +
            " (Arquivo #{i+1} de #{@files.length}) ---\n\n".bold
      cleanup_files = [f]
      if @change_encoding
        @tools.convert_encoding(f, "#{f.split('.')[0]}-encoded.csv",
                                @encoding_in, @encoding_out)
        f = "#{f.split('.')[0]}-encoded.csv"
        cleanup_files << f
      end
      unless @remove.empty?
        @remove.each_with_index do |r, i|
          @tools.remove_character(f, "#{f.split('.')[0]}-removed#{i + 1}.csv",
                                  r)
          f = "#{f.split('.')[0]}-removed#{i + 1}.csv"
          cleanup_files << f
        end
      end
      @tools.change_float_separator(f) if @change_float_point
      last_name = cleanup_files.pop
      remove_files = ''
      cleanup_files.each do |cf|
        remove_files = cf + ' '
      end
      @tools.clean_directory(remove_files)
      @tools.rename_file(last_name, cleanup_files[0])
    end
  end

  def main
    case @number_of_arguments
    when 0
      puts 'todo: mensagem de ajuda'
    when 1
      update_file
    else
      puts 'TODO:CASE ELSE'
    end
  end
end

Main.new.main
puts ''