#include <bits/stdc++.h>

#define MAX 200
#define EPS 1e-6
#define MOD 1000000007
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define sz size()
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

typedef long long ll;
typedef pair<int,int> ii;

vector<ii> graph[MAX];

struct Dijkstra {
  int N;
  vector<int> dist, vis;

  Dijkstra(int N) :
    N(N), dist(N), vis(N)
  {}

  void init() {
    fill(all(dist), inf);
    fill(all(vis), 0);
  }

  int run(int s, int d) {
    set<ii> pq;

    dist[s] = 0;
    pq.insert(ii(0, s));

    while (pq.size() != 0) {
      int u = pq.begin()->se;
      pq.erase(pq.begin());

      if (vis[u]) continue;
      vis[u] = 1;

      for (auto i : graph[u]) {
        int v = i.fi;
        int wt = i.se;

        if (!vis[v] && dist[v] > dist[u] + wt) {
          dist[v] = dist[u] + wt;
          pq.insert(ii(dist[v], v));
        }
      }
    }

    return dist[d];
  }
} dijkstra(MAX);

int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);

  int n, m;
  while (cin >> n >> m && (n || m)) {
    dijkstra.init();
    for (int i = 0; i <= n; ++i)
      graph[i].clear();

    for (int i = 0; i < m; ++i) {
      int o, d, t; cin >> o >> d >> t;
      graph[o].pb(ii(d, t));
    }

    int s, t; cin >> s >> t;
    int ans = dijkstra.run(s, t);
    cout << ((ans == inf) ? -1 : ans) << ende;
  }

  return 0;
}
