#include <bits/stdc++.h>

#define MAX 1010
#define EPS 1e-6
#define MOD 1000000007
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

typedef long long ll;
typedef pair<int,int> ii;

vector<int> graph[MAX];
int visited[MAX], parent[MAX];

int L[MAX];
int low[MAX];
vector<ii> bridges;

void dfs(int x) {
  int child = 0;
  visited[x] = 1;

  for (auto i : graph[x]) {
    if (!visited[i]) {
      child++;
      parent[i] = x;

      low[i] = L[i] = L[x] + 1;
      dfs(i);

      low[x] = min(low[x], low[i]);

      if (low[i] > L[x])
        bridges.pb(ii(x, i));

    } else if (parent[x] != i)
      low[x] = min(low[x], L[i]);
  }
}

void tarjan(int n) {
  mset(visited, 0);
  mset(parent, -1);
  mset(L, 0);
  bridges.clear();
  dfs(n);
}

int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);

  int n, m;
  while (cin >> n >> m && (n || m)) {
    for (int i = 0; i < n; ++i)
      graph[i].clear();

    for (int i = 0; i < m; ++i) {
      int x, y; cin >> x >> y;
      x--, y--;
      graph[x].pb(y);
      graph[y].pb(x);
    }

    tarjan(0);
    cout << (bridges.size() ? "N" : "S") << ende;
  }

  return 0;
}
