#include <bits/stdc++.h>

#define MAX 101010
#define EPS 1e-6
#define MOD 1000000007
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define sz size()
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

typedef long long ll;
typedef pair<int,int> ii;

typedef struct elem {
  int h, e, r;

  elem() : h(0), e(0), r(0) {}
  elem(int h, int e, int r) : h(h), e(e), r(r) {}

  elem operator+(const elem &x) {
    return elem(h + x.h, e + x.e, r + x.r);
  }

  void change(int n) {
    int a = h, b = e, c = r;
    if (n % 3 == 1) {
      e = a;
      r = b;
      h = c;
    } else if (n % 3 == 2) {
      e = c;
      r = a;
      h = b;
    }
  }
} elem;


int N;
elem v[MAX];
elem tree[MAX * 4];
int lazy[MAX * 4];

#define left(x) ((x << 1))
#define right(x) ((x << 1) + 1)

void build(int node = 1, int a = 0, int b = N - 1) {
  if (a > b) 
    return;

  if (a == b) {
    tree[node] = v[a];
    return;
  }

  build(left(node), a, (a + b) / 2);
  build(right(node), (a + b) / 2 + 1, b);
  tree[node] = tree[node * 2] + tree[node * 2 + 1];
}


void push(int node, int a, int b, int val) {
  tree[node].change(val);

  if (a != b) {
    lazy[left(node)] += val;
    lazy[right(node)] += val;
  }

  lazy[node] = 0;
}


void update(int i, int j, int node = 1, int a = 0, int b = N - 1) {
  if (lazy[node] != 0)
    push(node, a, b, lazy[node]);

  if (a > b or a > j or b < i) 
    return;

  if (a >= i and b <= j) {
    push(node, a, b, 1);
    return;
  }

  update(i, j, left(node), a, (a + b) / 2);
  update(i, j, right(node), (a + b) / 2 + 1, b);
  tree[node] = tree[node * 2] + tree[node * 2 + 1];
}


elem query(int i, int j, int node = 1, int a = 0, int b = N - 1) {
  if (a > b || a > j || b < i)
    return elem();

  if (lazy[node])
    push(node, a, b, lazy[node]);

  if (a >= i and b <= j)
    return tree[node];

  elem q1 = query(i, j, left(node), a, (a + b) / 2);
  elem q2 = query(i, j, right(node), (a + b) / 2 + 1, b);
  return q1 + q2;
}


int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);

  int m; 
  while (cin >> N >> m) {
    for (int i = 0; i < MAX * 4; ++i) {
      tree[i] = elem();
      lazy[i] = 0;
    }

    for (int i = 0; i < N; ++i) {
      v[i].h = 1;
      v[i].e = v[i].r = 0;
    }

    build();

    for (int i = 0; i < m; ++i) {
      char op;
      int a, b; cin >> op >> a >> b;

      if (op == 'C') {
        elem x = query(a - 1, b - 1);
        cout << x.h << " " << x.e << " " << x.r << ende;
      } else
        update(a - 1, b - 1);
    }

    cout << ende;
  }

  return 0;
}
