#include <bits/stdc++.h>

#define EPS 1e-6
#define MOD 1000000007
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

using ll = long long;
using ii = pair<int,int>;

const int base = 1000000000;
const int base_d = 9;

struct BigInt {
  int sign = 1;
  vector<int> num;

  BigInt() {}
  BigInt(ll x) { *this = x; }
  BigInt(const string &x) { read(x); }

  void operator=(ll x) {
    sign = 1;
    if (x < 0) sign = -1, x = -x;
    for (; x > 0; x /= base)
      num.pb(x % base);
  }

  BigInt operator+(const BigInt &x) const {
    if (sign != x.sign) return *this - (-x);

    BigInt ans = x;
    int carry = 0;
    for (int i = 0; i < max(size(), x.size()) || carry; ++i) {
      if (i == ans.size()) ans.push_back(0);

      if (i < size()) ans[i] += carry + num[i];
      else ans[i] += carry;

      carry = ans[i] >= base;
      if (carry) ans[i] -= base;
    }

    return ans;
  }

  BigInt operator-(const BigInt& x) const {
    if (sign != x.sign)
      return *this + (-x);
    if (abs() < x.abs())
      return -(x - *this);

    BigInt ans = *this;
    int carry = 0;
    for (int i = 0; i < x.size() || carry; ++i) {
      if (i < x.size()) ans[i] -= carry + x[i];
      else ans[i] -= carry;

      carry = ans[i] < 0;
      if (carry) ans[i] += base;
    }

    ans.trim();
    return ans;
  }

  void operator+=(const BigInt &v) {
    *this = *this + v;
  }
  void operator-=(const BigInt &v) {
    *this = *this - v;
  }

  void operator*=(int v) {
    if (v < 0) sign = -sign, v = -v;
    for (int i = 0, carry = 0; i < (int) size() || carry; ++i) {
      if (i == (int) size())
        num.push_back(0);

      ll cur = num[i] * (ll) v + carry;
      carry = (int) (cur / base);
      num[i] = (int) (cur % base);
    }

    trim();
  }

  BigInt operator*(int v) const {
    BigInt res = *this;
    res *= v;
    return res;
  }

  // Returns pair = (x / y, x % y).
  friend pair<BigInt,BigInt> divmod(const BigInt &x, 
      const BigInt &y) {
    int norm = base / (y.back() + 1);

    BigInt a = x.abs() * norm;
    BigInt b = y.abs() * norm;
    BigInt q, r;
    q.num.resize(a.size());

    for (int i = a.size() - 1; i >= 0; i--) {
      r *= base;
      r += a[i];
      int s1 = r.size() <= b.size() ? 0 : r.num[b.size()];
      int s2 = r.size() <= b.size() - 1 ? 0 : r.num[b.size() - 1];

      int d = ((ll) base * s1 + s2) / b.back();
      r -= b * d;
      while (r < 0) r += b, --d;
      q.num[i] = d;
    }

    q.sign = x.sign * y.sign;
    r.sign = x.sign;
    q.trim(); r.trim();
    return make_pair(q, r / norm);
  }

  BigInt operator/(const BigInt &x) const {
    return divmod(*this, x).fi;
  }

  void operator/=(int v) {
    if (v < 0) sign = -sign, v = -v;

    for (int i = (int) size() - 1, rem = 0; i >= 0; --i) {
      ll cur = num[i] + rem * (ll) base;
      num[i] = (int) (cur / v);
      rem = (int) (cur % v);
    }

    trim();
  }

  BigInt operator/(int x) const {
    BigInt res = *this;
    res /= x;
    return res;
  }

  // Removes leading zeros.
  void trim() {
    while (!num.empty() && num.back() == 0)
      num.pop_back();

    if (num.empty())
      sign = 1;
  }

  bool operator<(const BigInt &x) const {
    if (sign != x.sign)
      return sign < x.sign;

    if (size() != x.size())
      return (size() * sign) < (x.size() * x.sign);

    for (int i = size() - 1; i >= 0; i--)
      if (num[i] != x[i])
        return (num[i] * sign) < (x[i] * x.sign);

    return false;
  }

  bool operator==(const BigInt &x) const { return !(*this < x) && !(x < *this); }
  bool operator>(const BigInt &x)  const { return  (x < *this); }
  bool operator<=(const BigInt &x) const { return !(x < *this); }
  bool operator>=(const BigInt &x) const { return !(*this < x); }
  bool operator!=(const BigInt &x) const { return !(*this == x); }

  // Handles -x (change of sign).
  BigInt operator-() const {
    BigInt ans = *this;
    ans.sign = -sign;
    return ans;
  }

  // Returs absolute value.
  BigInt abs() const {
    BigInt ans = *this;
    ans.sign *= ans.sign;
    return ans;
  }

  // Transforms string into BigInt.
  void read(const string &s) {
    sign = 1;
    num.clear();

    int pos = 0;
    while (pos < (int) s.size() && 
        (s[pos] == '-' || s[pos] == '+')) 
    {
      if (s[pos] == '-')
        sign = -sign;
      ++pos;
    }

    for (int i = s.size() - 1; i >= pos; i -= base_d) {
      int x = 0;
      for (int j = max(pos, i - base_d + 1); j <= i; j++)
        x = x * 10 + s[j] - '0';
      num.push_back(x);
    }

    trim();
  }

  friend istream& operator>>(istream &stream, BigInt &v) {
    string s; stream >> s;
    v.read(s);
    return stream;
  }

  friend ostream& operator<<(ostream &stream, 
      const BigInt &x) {
    if (x.sign == -1)
      stream << '-';

    stream << (x.empty() ? 0 : x.back());
    for (int i = x.size() - 2; i >= 0; --i)
      stream << setw(base_d) << setfill('0') << x.num[i];

    return stream;
  }

  // Handles vector operations.
  int back() const { return num.back(); }
  bool empty() const { return num.empty(); }
  size_t size() const { return num.size(); }
  void push_back(int x) { num.push_back(x); }

  int &operator[](int i) { return num[i]; }
  int operator[](int i) const { return num[i]; }
};

int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);

  int n, f, cas = 1;
  while (cin >> n >> f && (n || f)) {
    vector<BigInt> v(n);
    for (int i = 0; i < n; ++i)
      cin >> v[i];

    BigInt sum = accumulate(all(v), BigInt("0"));
    cout << "Bill #" << cas << " costs " << sum << ": each friend should pay " << sum / f << ende;
    cout << ende;
    cas++;
  }

  return 0;
}
