#include <bits/stdc++.h>

#define EPS 1e-6
#define MOD 1000000007
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

using ll = long long;
using ii = pair<int,int>;

using point = pair<double,double>;

bool cw(point a, point b, point c) {
  return (b.fi - a.fi) * (c.se - a.se) - \
    (b.se - a.se) * (c.fi - a.fi) <= 0;
}

//double cross(point a, point b, point c) {
//  return (b.fi - a.fi) * (c.se - a.se) - \
//    (b.se - a.se) * (c.fi - a.fi);
//}
double cross(const point &o, const point &a, const point &b) {
  return (a.fi - o.fi) * (b.se - o.se) - (a.se - o.se) * (b.fi - o.fi);
}

vector<point> convex_hull(vector<point> &v) {
  int k = 0;
  vector<point> ans(v.size() * 2);

  sort(all(v), [](const point &a, const point &b) {
    return (a.fi == b.fi) ? (a.se < b.se) : (a.fi < b.fi);
  });

  for (int i = 0; i < v.size(); ++i) {
    for (; k >= 2 && cw(ans[k-2], ans[k-1], v[i]); --k);
    ans[k++] = v[i];
  }

  for (int i = v.size() - 2, t = k + 1; i >= 0; --i) {
    for (; k >= t && cw(ans[k-2], ans[k-1], v[i]); --k);
    ans[k++] = v[i];
  }

  ans.resize(k);
  return ans;
}

double dist_line(point p, point a, point b) {
  return cross(b, a, p) / sqrt((b.se-a.se) * (b.se-a.se) + (b.fi-a.fi)*(b.fi-a.fi));
}

double width(vector<point> &v) {
  vector<point> h = convex_hull(v);
  int n = h.size() - 1;
  int j = 1;

  double ans = 1e14;
  h[0] = h[n];
  for (int i = 1; i <= n; ++i) {
    while (cross(h[i-1], h[i], h[j%n+1]) > cross(h[i-1], h[i], h[j]))
      j = j % n + 1;
    ans = min(ans, dist_line(h[j], h[i], h[i-1]));
  }

  return ceil(ans*100)/100;
}

int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);
  cout << setprecision(2) << fixed;

  int n, cas = 1;
  while (cin >> n && n) {
    vector<point> v(n);
    for (int i = 0; i < n; ++i)
      cin >> v[i].fi >> v[i].se;

    cout << "Case " << cas << ": " << width(v) << ende;
    cas++;
  }

  return 0;
}
