#include <bits/stdc++.h>

#define MAX 1000
#define EPS 1e-6
#define MOD 1000000007
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

using ll = long long;
using ii = pair<int,int>;

vector<int> graph[MAX];

struct TopologicalSort {
  int N;
  stack<int> S;
  vector<int> cont;

  TopologicalSort(int N) :
    N(N), cont(N)
  {}

  void init() {
    fill(all(cont), 0);
  }

  bool dfs(int x) {
    cont[x] = 1;

    for (auto i : graph[x]) {
      if (cont[i] == 1)
        return true;
      if (!cont[i] && dfs(i))
        return true;
    }

    cont[x] = 2;
    S.push(x);

    return false;
  }

  bool run(vector<int> &tsort) {
    init();

    bool cycle = false;
    for (int i = 0; i < N; ++i) {
      if (!cont[i])
        cycle |= dfs(i);
    }

    if (cycle)
      return true;

    while (!S.empty()) {
      tsort.pb(S.top());
      S.pop();
    }

    return false;
  }
};

int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);

  int n;
  for (int cas = 1; cin >> n && n; ++cas) {
    for (int i = 0; i < MAX; ++i)
      graph[i].clear();

    vector<string> v(n);
    map<string,int> M;
    for (int i = 0; i < n; ++i) {
      cin >> v[i];
      M[v[i]] = i;
    }

    for (int i = 0; i < n; ++i) {
      string a; cin >> a;
      int m; cin >> m;
      for (int j = 0; j < m; ++j) {
        string b; cin >> b;
        graph[M[b]].pb(M[a]);
      }
    }

    TopologicalSort ts(n);
    vector<int> ans;
    bool cycle = ts.run(ans);

    cout << "Teste " << cas << ende;
    if (cycle)
      cout << "impossivel" << ende;
    else {
      for (auto i : ans)
        cout << v[i] << " ";
      cout << ende;
    }
    cout << ende;
  }

  return 0;
}
