#include <bits/stdc++.h>

#define EPS 1e-6
#define MOD 1000000007
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

using ll = long long;
using ii = pair<int,int>;

struct Dinic {
  struct Edge { int u, f, c, r; };

  int N;
  vector<int> depth, start;
  vector<vector<Edge>> graph;

  Dinic(int N) : 
    N(N), depth(N), start(N), graph(N) {}

  void add_edge(int s, int t, int c) {
    Edge forw = { t, 0, c, (int) graph[t].size() };
    Edge back = { s, 0, 0, (int) graph[s].size() };

    graph[s].pb(forw);
    graph[t].pb(back);
  }

  bool bfs(int s, int t) {
    queue<int> Q;
    Q.push(s);

    fill(all(depth), -1);
    depth[s] = 0;

    while (!Q.empty()) {
      int v = Q.front(); Q.pop();

      for (auto i : graph[v])
        if (depth[i.u] == -1 && i.f < i.c) {
          depth[i.u] = depth[v] + 1;
          Q.push(i.u);
        }
    }

    return depth[t] != -1;
  }

  int dfs(int s, int t, int f) {
    if (s == t)
      return f;

    for ( ; start[s] < graph[s].size(); ++start[s]) {
      Edge &e = graph[s][start[s]];

      if (depth[e.u] == depth[s] + 1 && e.f < e.c) {
        int min_f = dfs(e.u, t, min(f, e.c - e.f));

        if (min_f > 0) {
          e.f += min_f;
          graph[e.u][e.r].f -= min_f;
          return min_f;
        }
      }
    }

    return 0;
  }

  int run(int s, int t) {
    int ans = 0;
    while (bfs(s, t)) {
      fill(all(start), 0);

      while (int flow = dfs(s, t, inf))
        ans += flow;
    }

    return ans;
  }
};

int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);

  int n; cin >> n;
  vector<ii> v(n+1);
  for (int i = 1; i <= n; ++i)
    cin >> v[i].fi >> v[i].se;

  int ans = 0;
  for (int i = 1; i <= n; ++i) {
    int votes = 0, pass = 0;
    int s = 0, t = 2*n + 1;
    Dinic dinic(t + 1);

    for (int j = 1; j <= n; ++j) {
      if (i == j) 
        continue;

      if (v[j].fi == i || v[j].se == i) {
        votes++;
        continue;
      }
      
      dinic.add_edge(s, j, 1);
      dinic.add_edge(j, v[j].fi + n, 1);
      dinic.add_edge(j, v[j].se + n, 1);
      pass++;
    }

    for (int j = 1; j <= n; ++j)
      if (v[i].fi == j || v[i].se == j)
        dinic.add_edge(j + n, t, votes - 2);
      else
        dinic.add_edge(j + n, t, votes - 1);

    if (dinic.run(s, t) < pass)
      ans++;
  }

  cout << ans << ende;
  return 0;
}
