#include <bits/stdc++.h>

#define MAX 201010
#define EPS 1e-6
#define MOD 1000000007
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

using ll = long long;
using ii = pair<int,int>;
using iii = pair<ii,int>;

map<ii, bool> mst;
vector<ii> graph[MAX];
vector<iii> edges;

int pare[MAX];
int size[MAX];

void make_set(int x) {
  pare[x] = x;
  size[x] = 1;
}

int find_set(int x) {
  if (pare[x] != x)
    pare[x] = find_set(pare[x]);
  return pare[x];
}

void union_set(int x, int y) {
  x = find_set(x);
  y = find_set(y);

  if (x == y)
    return;

  if (size[x] > size[y])
    swap(x, y);

  pare[x] = y;
  size[y] += size[x];
}

int kruskal() {
  sort(all(edges), [&](const iii &a, const iii &b) {
    return a.se < b.se;    
  });

  int ans = 0;
  for (int i = 0; i < MAX; i++)
    make_set(i);

  for (int i = 0; i < edges.size(); i++) {
    int pu = find_set(edges[i].fi.fi);
    int pv = find_set(edges[i].fi.se);

    if (pu != pv) {
      mst[edges[i].fi] = true;

      graph[edges[i].fi.fi].pb(ii(edges[i].fi.se, edges[i].se));
      graph[edges[i].fi.se].pb(ii(edges[i].fi.fi, edges[i].se));

      ans += edges[i].se;
      union_set(pu, pv);
    }
  }

  return ans;
}

#define MAXLOG 20

int h[MAX];
int par[MAX][MAXLOG];
int cost[MAX][MAXLOG];

void dfs(int v, int p = -1, int c = 0) {
  par[v][0] = p;
  cost[v][0] = c;

  if (p != -1)
    h[v] = h[p] + 1;

  for (int i = 1; i < MAXLOG; ++i)
    if (par[v][i - 1] != -1) {
      par[v][i] = par[par[v][i - 1]][i - 1];
      cost[v][i] = max(cost[v][i], max(cost[par[v][i-1]][i-1], cost[v][i-1]));
    }

  for (auto u : graph[v]) 
    if (p != u.fi)
      dfs(u.fi, v, u.se);
}

void preprocess(int v) {
  memset(par, -1, sizeof par);
  memset(cost, 0, sizeof cost);
  dfs(v);
}

int query(int p, int q) {
  int ans = 0;

  if (h[p] < h[q])
    swap(p, q);

  for (int i = MAXLOG - 1; i >= 0; --i)
    if (par[p][i] != -1 && h[par[p][i]] >= h[q]) {
      ans = max(ans, cost[p][i]);
      p = par[p][i];
    }

  if (p == q)
    return ans;

  for (int i = MAXLOG - 1; i >= 0; --i)
    if (par[p][i] != -1 && par[p][i] != par[q][i]) {
      ans = max(ans, max(cost[p][i], cost[q][i]));
      p = par[p][i];
      q = par[q][i];
    }

  if (p == q) return ans;
  else return max(ans, max(cost[p][0], cost[q][0]));
}

int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);

  int n, r; cin >> n >> r;
  map<ii,int> M;

  for (int i = 0; i < r; ++i) {
    int a, b, c; cin >> a >> b >> c;
    a--, b--;
    M[ii(a, b)] = c;
    M[ii(b, a)] = c;
    edges.pb(iii(ii(a, b), c));
    edges.pb(iii(ii(b, a), c));
  }

  int vmst = kruskal();
  preprocess(0);

  int q; cin >> q;
  for (int i = 0; i < q; ++i) {
    int a, b; cin >> a >> b;
    a--, b--;

    if (mst[ii(a, b)] || mst[ii(b, a)])
      cout << vmst << ende;
    else
      cout << vmst - query(a, b) + M[ii(a, b)] << ende;
  }

  return 0;
}
