#include <bits/stdc++.h>

#define MAX 101010
#define EPS 1e-6
#define MOD 1000000007
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

using ll = long long;
using ii = pair<int,int>;
using iii = pair<ii,int>;

vector<int> sieve(int n) {
  vector<int> primes;
  vector<bool> is_prime(n+1, true);

  for (int p = 2; p*p <= n; ++p)
    if (is_prime[p])
      for (int i = p*p; i <= n; i += p)
        is_prime[i] = false;

  for (int p = 2; p <= n; ++p)
    if (is_prime[p])
      primes.pb(p);

  return primes;
}

int N;
int v[MAX];
int tree[4 * MAX];

#define left(x) (x << 1)
#define right(x) ((x << 1) + 1)

void build(int node = 1, int a = 0, int b = N - 1) {
  if (a > b) 
    return;

  if (a == b) {
    tree[node] = v[a];
    return;
  }

  build(left(node), a, (a + b) / 2);
  build(right(node), 1 + (a + b) / 2, b);
  tree[node] = tree[node * 2] + tree[node * 2 + 1];
}

void update(int idx, int val, int node = 1, int a = 0, int b = N - 1) {
  if (a > b || a > idx || b < idx) 
    return;

  if (a == b) {
    tree[node] += val;
    return;
  }

  update(idx, val, left(node), a, (a + b) / 2);
  update(idx, val, right(node), 1 + (a + b) / 2, b);
  tree[node] = tree[node * 2] + tree[node * 2 + 1];
}

int query(int i, int j, int node = 1, int a = 0, int b = N - 1) {
  if (a > b || a > j || b < i) 
    return 0;

  if (i <= a && b <= j) 
    return tree[node];

  int q1 = query(i, j, left(node), a, (a + b) / 2);
  int q2 = query(i, j, right(node), 1 + (a + b) / 2, b);
  return q1 + q2;
}

int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);

  vector<int> primes = sieve(100000);

  int q; cin >> q;
  vector<iii> que(q);
  for (int i = 0; i < q; ++i) {
    int n, k; cin >> n >> k;
    que[i] = {ii(k, n), i};
  }

  N = 100001;
  fill(v, v+N, 1);
  build();

  vector<int> ans(q);
  int curr = primes.size() - 1;
  sort(rall(que));
  for (auto i : que) {
    while (curr >= 0 && primes[curr] > i.fi.fi) {
      for (int j = primes[curr]; j <= N; j += primes[curr])
        if (query(j, j) != 0) 
          update(j, -1);

      curr--;
    }

    ans[i.se] = query(2, i.fi.se);
  }

  for (int i = 0; i < q; ++i)
    cout << ans[i] << ende;
  return 0;
}
