#include <bits/stdc++.h>

#define MAX 101010
#define EPS 1e-6
#define MOD 1000000007
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define sz size()
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

typedef long long ll;
typedef pair<int,int> ii;

typedef struct elem {
  int freq[9];

  elem() {
    for (int i = 0; i < 9; ++i) freq[i] = 0;
  }

  elem(int x) {
    for (int i = 0; i < 9; ++i) freq[i] = 0;
    freq[x] = 1;
  }

  elem operator+(const elem &a) {
    elem e;
    for (int i = 0; i < 9; ++i)
      e.freq[i] = a.freq[i] + freq[i];
    return e;
  }

  void change(int x) {
    vector<int> aux(9, 0);
    for (int i = 0; i < 9; ++i)
      aux[(i + x) % 9] += freq[i];

    for (int i = 0; i < 9; ++i)
      freq[i] = aux[i];
  }
} elem;


int N;
elem v[MAX];
elem tree[4 * MAX];
int lazy[4 * MAX];

#define left(x) (x << 1)
#define right(x) ((x << 1) + 1)

void build(int node = 1, int a = 0, int b = N - 1) {
  if (a > b) 
    return;

  if (a == b) {
    tree[node] = v[a];
    return;
  }

  build(left(node), a, (a + b) / 2);
  build(right(node), (a + b) / 2 + 1, b);
  tree[node] = tree[node * 2] + tree[node * 2 + 1];
}


void push(int node, int a, int b, int val) {
  tree[node].change(val);

  if (a != b) {
    lazy[left(node)] += val;
    lazy[right(node)] += val;
  }

  lazy[node] = 0;
}


void update(int i, int j, int val, int node = 1, int a = 0, int b = N - 1) {
  if (lazy[node] != 0)
    push(node, a, b, lazy[node]);

  if (a > b || a > j || b < i) 
    return;

  if (i <= a && b <= j) {
    push(node, a, b, val);
    return;
  }

  update(i, j, val, left(node), a, (a + b) / 2);
  update(i, j, val, right(node), (a + b) / 2 + 1, b);
  tree[node] = tree[node * 2] + tree[node * 2 + 1];
}


elem query(int i, int j, int node = 1, int a = 0, int b = N - 1) {
  if (a > b || a > j || b < i)
    return elem();

  if (lazy[node])
    push(node, a, b, lazy[node]);

  if (a >= i && b <= j)
    return tree[node];

  elem q1 = query(i, j, left(node), a, (a + b) / 2);
  elem q2 = query(i, j, right(node), (a + b) / 2 + 1, b);
  return q1 + q2;
}


int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);

  int n, q; cin >> n >> q;
  for (int i = 0; i < n; ++i)
    v[i] = elem(1);

  N = n;
  build();

  for (int i = 0; i < q; ++i) {
    int a, b; cin >> a >> b;
    elem e = query(a, b);

    int grt = 0;
    for (int i = 1; i < 9; ++i)
      if (e.freq[i] >= e.freq[grt])
        grt = i;

    update(a, b, grt);
  }

  for (int i = 0; i < n; ++i) {
    elem e = query(i, i);

    int grt = 0;
    for (int i = 0; i < 9; ++i)
      if (e.freq[i] >= e.freq[grt])
        grt = i;

    cout << grt << ende;
  }

  return 0;
}
