#include <bits/stdc++.h>

#define EPS 1e-6
#define MOD 1000000007
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

using ll = long long;
using ii = pair<int,int>;
using iii = pair<ii,int>;

struct Dinic {
  struct Edge { int u, f, c, r; };

  int N;
  vector<int> depth, start;
  vector<vector<Edge>> graph;

  Dinic(int N) : 
    N(N), depth(N), start(N), graph(N) {}

  void add_edge(int u, int v, int c) {
    Edge forw = { v, 0, c, (int) graph[v].size() };
    Edge back = { u, 0, 0, (int) graph[u].size() };
    graph[u].pb(forw);
    graph[v].pb(back);
  }

  bool bfs(int s, int t) {
    queue<int> Q;
    Q.push(s);

    fill(all(depth), -1);
    depth[s] = 0;

    while (!Q.empty()) {
      int v = Q.front(); Q.pop();

      for (auto i : graph[v])
        if (depth[i.u] == -1 && i.f < i.c) {
          depth[i.u] = depth[v] + 1;
          Q.push(i.u);
        }
    }

    return depth[t] != -1;
  }

  int dfs(int s, int t, int f) {
    if (s == t) return f;

    for ( ; start[s] < graph[s].size(); ++start[s]) {
      Edge &e = graph[s][start[s]];

      if (depth[e.u] == depth[s] + 1 && e.f < e.c) {
        int min_f = dfs(e.u, t, min(f, e.c - e.f));

        if (min_f > 0) {
          e.f += min_f;
          graph[e.u][e.r].f -= min_f;
          return min_f;
        }
      }
    }

    return 0;
  }

  int run(int s, int t) {
    int ans = 0;
    while (bfs(s, t)) {
      fill(all(start), 0);
      while (int flow = dfs(s, t, inf))
        ans += flow;
    }
    return ans;
  }
};

int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);

  int p, r, c; cin >> p >> r >> c;
  vector<int> vp(p);
  vector<int> vr(r);

  int sum = 0;
  for (auto &i : vp) {
    cin >> i;
    sum += i;
  }

  for (auto &i : vr) cin >> i;

  vector<iii> v(c);
  for (int i = 0; i < c; ++i) {
    int a, b, x; cin >> a >> b >> x;
    v[i] = {{a, b}, x};
  }

  int L = 0, R = 1001000;
  for (int i = 0; i < 30; ++i) {
    int m = (L + R) / 2;

    Dinic dinic(r + p + 5);
    for (int j = 0; j < r; ++j)
      dinic.add_edge(0, j + 1, vr[j]);
    for (int j = 0; j < p; ++j)
      dinic.add_edge(j + 1 + r, r + p + 4, vp[j]);

    for (int j = 0; j < c; ++j)
      if (v[j].se <= m)
        dinic.add_edge(v[j].fi.se, v[j].fi.fi + r, inf);

    if (dinic.run(0, r + p + 4) < sum) 
      L = m;
    else 
      R= m;
  }

  cout << ((R > 1000100) ? -1 : R) << ende;
  return 0;
}
