#include <bits/stdc++.h>

#define MAX 101010
#define MLOG 17
#define EPS 1e-6
#define MOD 1000000007
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

using ll = long long;
using ii = pair<int,int>;

int h[MAX];
int par[MAX][MLOG];
vector<int> graph[MAX];

void dfs(int x, int p) {
  par[x][0] = p;

  if (p != -1)
    h[x] = h[p] + 1;

  for (int i = 1; i < MLOG; ++i)
    if (par[x][i-1] != -1)
      par[x][i] = par[par[x][i-1]][i-1];

  for (auto i : graph[x])
    if (i != p)
      dfs(i, x);
}

int lca(int a, int b) {
  if (h[a] < h[b])
    swap(a, b);

  for (int i = MLOG - 1; i >= 0; --i)
    if (par[a][i] != -1 && h[par[a][i]] >= h[b])
      a = par[a][i];

  if (a == b)
    return a;

  for (int i = MLOG - 1; i >= 0; --i)
    if (par[a][i] != -1 && par[a][i] != par[b][i]) {
      a = par[a][i];
      b = par[b][i];
    }

  return par[a][0];
}

int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);

  int n, q; cin >> n >> q;
  for (int i = 0; i < n - 1; ++i) {
    int a, b; cin >> a >> b; a--, b--;
    graph[a].pb(b);
    graph[b].pb(a);
  }

  mset(h, 0);
  mset(par, -1);
  dfs(0, -1);

  for (int i = 0; i < q; ++i) {
    int a, b, c, d; 
    cin >> a >> b >> c >> d; a--, b--, c--, d--;
    vector<int> v = { lca(a, c), lca(a, d), lca(b, c), lca(b, d) };

    sort(all(v), [&](int a, int b) {
      return h[a] > h[b];
    });

    if (v[0] == v[1]) {
      bool t1 = ((lca(a, v[0]) == v[0] || lca(b, v[0]) == v[0]) && h[lca(a, b)] <= h[v[0]]);
      bool t2 = ((lca(c, v[0]) == v[0] || lca(d, v[0]) == v[0]) && h[lca(c, d)] <= h[v[0]]);
      cout << (t1 && t2) << ende;
    } else {
      int aux = lca(v[0], v[1]);

      if (aux == v[0] || aux == v[1])
        cout << abs(h[v[0]] - h[v[1]]) + 1 << ende;
      else
        cout << (h[v[0]] - h[aux] + 1) + (h[v[1]] - h[aux] + 1) - 1 << ende;
    }
  }

  return 0;
}
