#include <bits/stdc++.h>

#define MAX 300
#define EPS 1e-6
#define MOD 1000000007
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define sz size()
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

typedef long long ll;
typedef pair<int,int> ii;

int N;
int par[MAX];
int graph[MAX][MAX], rg[MAX][MAX];

bool cont[MAX];

bool path(int s, int t) {
  cont[s] = true;
  if (s == t)
    return true;

  for (int i = 0; i < N; ++i)
    if (!cont[i] && rg[s][i]) {
      par[i] = s;

      if (path(i, t)) 
        return true;
    }

  return false;
}


int ford_fulkerson(int s, int t) {
  int ans = 0;
  par[s] = -1;

  mset(cont, 0);
  memcpy(rg, graph, sizeof(graph));

  while (path(s, t)) {
    int flow = inf;

    for (int i = t; par[i] != -1; i = par[i])
      flow = min(flow, rg[par[i]][i]);

    for (int i = t; par[i] != -1; i = par[i]) {
      rg[par[i]][i] -= flow;
      rg[i][par[i]] += flow;
    }

    ans += flow;
    mset(cont, 0);
  }

  return ans;
}


int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);

  int n, m, k, cas = 1;
  while (cin >> n >> m >> k) {
    mset(graph, 0);

    N = MAX;
    int s = 0, t = MAX-1;
    for (int i = 1; i <= n; ++i) {
      int c; cin >> c;
      graph[i + 120][t] = c;
    }

    for (int i = 0; i < k; ++i) {
      int x, y; cin >> x >> y;
      graph[y][x + 120] = 1;
    }

    for (int i = 1; i <= m; ++i)
      graph[s][i] = 1;

    cout << "Instancia " << cas++ << ende;
    cout << ford_fulkerson(s, t) << ende;
    cout << ende;
  }
  return 0;
}
