#include <bits/stdc++.h>

#define EPS 1e-6
#define MOD 1000000007
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

typedef unsigned long long ll;
typedef pair<int,int> ii;

struct matrix {
  int N;
  ll b;
  vector<vector<ll>> m;

  matrix(int N, ll b) : N(N), b(b) {
    m = vector<vector<ll>>(N, vector<ll>(N, 0));
  }

  matrix operator*(matrix a) {
    matrix res(N, b);
    for (int i = 0; i < N; i++)
      for (int j = 0; j < N; j++) {
        res[i][j] = 0;

        for (int k = 0; k < N; k++)
          res[i][j] = (((m[i][k] * a[k][j]) % b) + res[i][j]) % b; 
      }
    
    return res;
  }

  void to_identity() {
    for (auto &i : m)
      fill(all(i), 0);
    for (int i = 0; i < N; ++i)
      m[i][i] = 1;
  }

  vector<ll> &operator[](int i) {
    return m[i];
  }
};

ll fast_pow(matrix in, ll n, ll b) {
  matrix ans(2, b);
  ans.to_identity();

  while (n) {
    if (n & 1)
      ans = ans * in; 

    n >>= 1;
    in = in * in;
  }

  return ans[0][0];
}

ll solve(ll n, ll b) {
  matrix in(2, b);

  in[0][0] = 1;
  in[0][1] = 1;

  in[1][0] = 1;
  in[1][1] = 0;

  return fast_pow(in, n, b);
}

int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);

  ll n, b;
  int cas = 1;
  while (cin >> n >> b && (n || b)) {
    ll ans = solve(n, b) % b;
    ans = (ans + ans) % b;
    ans = (ans - 1 + b) % b;

    cout << "Case " << cas++ << ":" << " " << n << " " << b << " " << ans << ende;
  }

  return 0;
}
