#include <bits/stdc++.h>

#define MAX 101010
#define EPS 1e-6
#define MOD 1000000007
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define sz size()
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

typedef long long ll;
typedef pair<int,int> ii;

ll tree[MAX];
ll b, p, l, n;

ll query(ll idx) {
  ll sum = 0;
  for (; idx > 0; idx -= (idx & -idx))
    sum = (sum + tree[idx] + p) % p;

  return sum % p;
}


void update(ll idx, ll val) {
  for (; idx <= MAX; idx += (idx & -idx))
    tree[idx] = (tree[idx] + val + p) % p;
}


ll power(ll x, ll y) {
  ll ans = 1;

  while (y) {
    if (y & 1)
      ans = (ans * x) % p;

    y >>= 1;
    x = (x * x) % p;
  }

  return ans % p;
}


ll mod_inverse(ll a) {
  return power(a, p - 2);
}


int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);

  while (cin >> b >> p >> l >> n && (b || p || l || n)) {
    mset(tree, 0);

    vector<ll> powB(l + 1); powB[0] = 1;
    for (int i = 1; i <= l; ++i)
      powB[i] = (powB[i-1] * (b % p)) % p;

    for (int i = 0; i < n; ++i) {
      string op; cin >> op;

      if (op[0] == 'E') {
        ll pos, val; cin >> pos >> val;

        // Remove current value from bit
        update(pos, -((query(pos) - query(pos - 1) + p) % p));

        // Insert new value into bit (val*b^(l-pos))
        update(pos, ((val % p) * powB[l - pos]) % p);
      } else {
        ll L, R; cin >> L >> R;

        // Get range sum
        ll sum = (query(R) - query(L - 1) + p) % p;

        // Result is (sum / b^(l-R)) % p
        cout << (sum * mod_inverse(powB[l - R])) % p << ende;
      }
    }

    cout << "-" << ende;
  }

  return 0;
}
