#include <bits/stdc++.h>

#define MAXN 110
#define MAXM 20010
#define EPS 1e-6
#define MOD 1000000007
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

using ll = long long;
using ii = pair<int,int>;

struct MinCostMaxFlow {
  struct Edge {
    int u, v, cap, cost;
  };

  int N;
  vector<Edge> edges;
  vector<vector<int>> adj;
  vector<int> vis, dist, par, ind;

  MinCostMaxFlow(int N) :
    N(N), vis(N), dist(N), par(N), ind(N), adj(N) {}

  void add_edge(int u, int v, int cap, int cost) {
    adj[u].pb(edges.size());
    edges.pb({ u, v, cap, cost });

    adj[v].pb(edges.size());
    edges.pb({ v, u, 0, -cost });
  }

  bool spfa(int s, int t) {
    fill(all(dist), inf);
    dist[s] = 0;

    queue<int> Q;
    Q.push(s);

    while (!Q.empty()) {
      int u = Q.front(); Q.pop();
      vis[u] = 0;

      for (auto i : adj[u]) {
        Edge &e = edges[i];
        int v = e.v;

        if (e.cap > 0 && dist[v] > dist[u] + e.cost) {
          dist[v] = dist[u] + e.cost;
          par[v] = u;
          ind[v] = i;

          if (!vis[v]) {
            Q.push(v);
            vis[v] = 1;
          }
        }
      }
    }

    return dist[t] < inf;
  }

  pair<ll,int> run(int s, int t) {
    ll mincost = 0;
    int maxflow = 0;

    while (spfa(s, t)) {
      ll flow = inf;
      for (int i = t; i != s; i = par[i])
        flow = min(flow, (ll) edges[ind[i]].cap);
      
      for (int i = t; i != s; i = par[i]) {
        edges[ind[i]  ].cap -= flow;
        edges[ind[i]^1].cap += flow;
      }

      mincost += flow * dist[t];
      maxflow += flow;
    }

    return make_pair(mincost, maxflow);
  }
};

int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);

  int n, m;
  while (cin >> n >> m) {
    MinCostMaxFlow mcmf(110);

    vector<pair<ii,int>> aux(m);
    for (int i = 0; i < m; ++i)
      cin >> aux[i].fi.fi >> aux[i].fi.se >> aux[i].se;

    int d, k; cin >> d >> k;
    mcmf.add_edge(0, 1, d, 0);
    for (int i = 0; i < m; ++i) {
      mcmf.add_edge(aux[i].fi.fi, aux[i].fi.se, k, aux[i].se);
      mcmf.add_edge(aux[i].fi.se, aux[i].fi.fi, k, aux[i].se);
    }

    pair<ll,int> ans = mcmf.run(0, n);

    if (ans.se != d) cout << "Impossible." << ende;
    else cout << ans.fi << ende;
  }

  return 0;
}
