#include <bits/stdc++.h>

#define EPS 1e-6
#define MOD 1000000007
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

typedef long long ll;
typedef pair<int,int> ii;

struct comp {
  float r, i;

  comp() : r(0), i(0) {}
  comp(float r, float i) : r(r), i(i) {}

  comp operator+(comp b) { 
    return comp(r + b.r, i + b.i); 
  }

  comp operator-(comp b) {
    return comp(r - b.r, i - b.i);
  }

  comp operator*(comp b) {
    return comp(r * b.r - i * b.i, r * b.i + i * b.r);
  }

  comp operator/(comp b) {
    float div = (b.r * b.r) + (b.i * b.i);
    return comp((r * b.r + i * b.i) / div, (i * b.r - r * b.i) / div);
  }
};


// Returns complex conjugate
inline comp conj(comp a) {
  return comp(a.r, -a.i);
}

vector<int> rev = {0, 1};
vector<comp> roots = {{0, 0}, {1, 0}};


// Initializes reversed-bit vector (rev) and roots of unity vector (roots)
void init(int nbase) {
  rev.resize(1 << nbase);
  roots.resize(1 << nbase);

  // Construct rev vector
  for (int i = 0; i < (1 << nbase); ++i)
    rev[i] = (rev[i >> 1] >> 1) + ((i & 1) << (nbase - 1));

  // Construct roots vector
  for (int base = 1; base < nbase; ++base) {
    float angle = 2 * M_PI / (1 << (base + 1));

    for (int i = 1 << (base - 1); i < (1 << base); ++i) {
      float angle_i = angle * (2 * i + 1 - (1 << base));

      roots[i << 1] = roots[i];
      roots[(i << 1) + 1] = comp(cos(angle_i), sin(angle_i));
    }
  }
}


// Applies FFT on vector a
void fft(vector<comp> &a) {
  int n = a.size();

  // Change order of elements to match the end of recursion
  for (int i = 0; i < n; ++i)
    if (i < rev[i])
      swap(a[i], a[rev[i]]);

  // Iterate through "recursion tree"
  for (int s = 1; s < n; s <<= 1) {

    // Iterate through all pairs of vectors (tree leaves)
    for (int k = 0; k < n; k += (s << 1)) {

      // Execute "combine step"
      for (int j = 0; j < s; ++j) {
        comp z = a[k + j + s] * roots[j + s];

        a[k + j + s] = a[k + j] - z;
        a[k + j] = a[k + j] + z;
      }
    }
  }
}


// Multiplies vectors a and b using FFT
vector<int> multiply(vector<int> &a, vector<int> &b) {
  int nbase, need = a.size() + b.size() + 1;

  for (nbase = 0; (1 << nbase) < need; ++nbase);
  init(nbase);

  int size = 1 << nbase;
  vector<comp> fa(size);

  // Assemble vector fa from a and b
  for (int i = 0; i < size; ++i) {
    int x = (i < a.size() ? a[i] : 0);
    int y = (i < b.size() ? b[i] : 0);
    fa[i] = comp(x, y);
  }

  fft(fa);

  // Multiply vectors using magic
  comp r(0, -0.25 / size);
  for (int i = 0; i <= (size >> 1); ++i) {
    int j = (size - i) & (size - 1);
    comp z = (fa[j] * fa[j] - conj(fa[i] * fa[i])) * r;

    if (i != j)
      fa[j] = (fa[i] * fa[i] - conj(fa[j] * fa[j])) * r;
    fa[i] = z;
  }

  fft(fa);

  // Obtain result vector
  vector<int> res(need);
  for (int i = 0; i < need; ++i)
    res[i] = fa[i].r + 0.5;

  return res;
}

int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);

  string s; cin >> s;
  int n = s.size();

  int acc = 0, sum = s[0] - 'a' + 1;
  for (int i = 1; i < n; ++i)
    sum += s[i] - 'a' + 1;

  vector<int> a(sum + 1), b(sum + 1);
  a[0] = b[sum] = 1;
  for (int i = 0; i < n; ++i) {
    acc += s[i] - 'a' + 1;
    a[acc] = b[sum - acc] = 1;
  }

  vector<int> c = multiply(a, b);
  int ans = 0;
  for (int i = sum + 1; i <= 2 * sum; ++i)
    if (c[i]) ans++;

  cout << ans << ende;
  return 0;
}
