#include <bits/stdc++.h>

#define EPS 1e-6
#define MOD 1000000007
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

using ll = long long;
using ii = pair<ll,ll>;
using iii = pair<ll,ii>;

ii operator+(const ii &a, const ii &b) {
  return ii(a.fi + b.fi, a.se + b.se);
}

struct Dijkstra {
  int N;
  vector<ll> dist;
  vector<int> cont;
  vector<vector<iii>> graph;

  Dijkstra(int N) :
    N(N), dist(N, llinf), cont(N, 0), graph(N)
  {}

  ll run(int s) {
    set<iii> pq;

    ll ans = 0;
    dist[s] = 0;
    pq.insert(iii(0, ii(s, 0)));

    while (pq.size() != 0) {
      iii top = *(pq.begin());
      pq.erase(pq.begin());

      int u = top.se.fi;
      if (cont[u])
        continue;

      cont[u] = 1;
      ans += top.se.se;

      for (auto i : graph[u]) {
        int v = i.fi;
        ll wt = i.se.fi;

        if (!cont[v] && dist[v] >= top.fi + wt) {
          dist[v] = top.fi + wt;
          pq.insert(iii(dist[v], ii(v, i.se.se)));
        }
      }
    }

    return ans;
  } 
};

int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);

  int n, m; cin >> n >> m;
  Dijkstra d(n+2);
  map<ii,ii> M;
  for (int i = 0; i < m; ++i) {
    int a, b; ll l, c; 
    cin >> a >> b >> l >> c;
    if (M.find(ii(a, b)) != M.end()) {
      M[ii(a, b)] = min(M[ii(a, b)], ii(l, c));
      M[ii(b, a)] = M[ii(a, b)];
    } else {
      M[ii(a, b)] = {l, c};
      M[ii(b, a)] = {l, c};
    }
  }

  for (auto i : M)
    d.graph[i.fi.fi].pb({i.fi.se, i.se});

  ll ans = d.run(1);
  cout << ans << ende;
  return 0;
}
