#include <bits/stdc++.h>

#define MAX 101010
#define EPS 1e-6
#define MOD 1000000007
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define sz size()
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

typedef long long ll;
typedef pair<int,int> ii;

ll N, tree[4 * MAX], v[MAX];

void build_tree(int node = 1, int a = 0, int b = N) {
  if (a > b)
    return;

  if (a == b) {
    tree[node] = v[a];
    return;
  }

  build_tree(node * 2, a, (a + b) / 2);
  build_tree(node * 2 + 1, 1 + (a + b) / 2, b);

  tree[node] = max(tree[node * 2], tree[node * 2 + 1]);
}


void update_tree(int idx, ll val, int node = 1, int a = 0, int b = N) {
  if (a > b || a > idx || b < idx)
    return;

  if (a == b) {
    tree[node] = val;
    return;
  }

  update_tree(idx, val, node * 2, a, (a + b) / 2);
  update_tree(idx, val, node * 2 + 1, 1 + (a + b) / 2, b);

  tree[node] = max(tree[node * 2], tree[node * 2 + 1]);
}


int query_tree(int i, int j, int node = 1, int a = 0, int b = N) {
  if (a > b || a > j || b < i)
    return 0;

  if (a >= i && b <= j)
    return tree[node];

  int res1 = query_tree(i, j, node * 2, a, (a + b) / 2);
  int res2 = query_tree(i, j, node * 2 + 1, 1 + (a + b) / 2, b);

  return max(res1, res2);
}


int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);

  ll t, n, m;
  cin >> t;
  for (int cas = 0; cas < t; ++cas) {
    cout << "Testcase " << cas << ":\n";
    cin >> n >> m;
    N = n;

    for (int i = 0; i < n; ++i)
      cin >> v[i];
    build_tree();

    ll q, a, b;
    string op;
    cin >> q;
    for (int i = 0; i < q; ++i) {
      cin >> op;
      if (op[0] == 'A') {
        cin >> a;
        m += a;
      } else if (op[0] == 'B') {
        cin >> a >> b;
        update_tree(a, b);
      } else {
        cin >> a >> b;
        cout << abs(m - query_tree(a, b)) << '\n';
      }
    }
    cout << '\n';
  }

  return 0;
}
