#include <bits/stdc++.h>

#define MAX 101010
#define MOD 1000000007
#define EPS 1e-6
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define sz size()
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

typedef long long ll;
typedef pair<int,int> ii;

int h[MAX];
int par[MAX][20];
vector<int> graph[MAX];


void dfs(int v, int p = -1) {
  par[v][0] = p;

  if (p != -1)
    h[v] = h[p] + 1;

  for (int i = 1; i < 20; ++i)
    if (par[v][i-1] != -1)
      par[v][i] = par[par[v][i-1]][i-1];

  for (auto u : graph[v])
    if (p != u)
      dfs(u, v);
}


int lca(int p, int q) {
  if (h[p] < h[q])
    swap(p, q);

  for (int i = 19; i >= 0; --i)
    if (par[p][i] != -1 and h[par[p][i]] >= h[q])
      p = par[p][i];

  if (p == q)
    return p;

  for (int i = 19; i >= 0; --i)
    if (par[p][i] != -1 and par[p][i] != par[q][i]) {
      p = par[p][i];
      q = par[q][i];
    }

  return par[p][0];
}


int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);

  int a, b, c, d;
  int n, q; cin >> n >> q;
  for (int i = 0; i < n - 1; ++i) {
    cin >> a >> b;
    graph[a].pb(b);
    graph[b].pb(a);
  }

  mset(par, -1);
  dfs(1);

  for (int i = 0; i < q; ++i) {
    cin >> a >> b >> c >> d;

    int lab = lca(a, b);
    int lac = lca(a, c);
    int lad = lca(a, d);
    int lbc = lca(b, c);
    int lbd = lca(b, d);
    int lcd = lca(c, d);

    // If path C->D is above (or different subtree) than A->B and has no intersection
    if (h[lca(c, lab)] < h[lab] and h[lca(d, lab)] < h[lab])
      cout << 0 << ende;

    // If path A->B is above (or different subtree) than C->D and has no intersection
    else if (h[lca(a, lcd)] < h[lcd] and h[lca(b, lcd)] < h[lcd])
      cout << 0 << ende;

    // There is an intersection
    else {

      // If lca(A, B) belongs to the path C->D
      if (h[lcd] < h[lab]) {
        
        // If intersection occurs between C->lca(C,D)
        if (h[lac] > h[lcd] or h[lbc] > h[lcd]) cout << abs(h[lca(lac, c)] - h[lca(lbc, c)]) + 1 << ende; 

        // If intersection occurs between D->lca(C,D)
        else cout << abs(h[lca(lad, d)] - h[lca(lbd, d)]) + 1 << ende;


      // If lca(C, D) belongs to the path A->B
      } else if (h[lab] < h[lcd]) {

       // If intersection occurs between A->lca(A,B)
        if (h[lac] > h[lab] or h[lad] > h[lab]) cout << abs(h[lca(lac, a)] - h[lca(lad, a)]) + 1 << ende;

        // If intersection occurs between B->lca(A,B)
        else cout << abs(h[lca(lbc, b)] - h[lca(lbd, b)]) + 1 << ende;


      // It means that lca(A, B) is the same node as lca(C, D)
      } else {

        // If A and C are on the same side -> B and D are on the same side
        if (h[lac] > h[lcd] or h[lbd] > h[lcd]) cout << (h[lac] - h[lcd]) + (h[lbd] - h[lcd]) + 1 << ende; 

        // If A and D are on the same side -> B and C are on the same side
        else cout << (h[lad] - h[lcd]) + (h[lbc] - h[lcd]) + 1 << ende;
      }
    }
  }

  return 0;
}
