#!/bin/bash
username=$1
password=$2
path=$3

user_home="$path/$username"
ecryptfs_path="$path/.ecryptfs"
user_ecrypt_path="$ecryptfs_path/$username"

if [ ! -d "$ecryptfs_path" ]; then
	mkdir $ecryptfs_path
fi

mkdir -p $user_ecrypt_path
mkdir -m 700 "$user_ecrypt_path/.ecryptfs"
mkdir -m 700 "$user_ecrypt_path/.Private"

touch "$user_ecrypt_path/.ecryptfs/auto-mount"
touch "$user_ecrypt_path/.ecryptfs/auto-umount"

echo "/home/$username" > "$user_ecrypt_path/.ecryptfs/Private.mnt"

sigpath="$user_ecrypt_path/.ecryptfs/Private.sig"
wrapped="$user_ecrypt_path/.ecryptfs/wrapped-passphrase"

mountpass=$(openssl rand -base64 32)

printf "%s\n%s" "$mountpass" "$password" | ecryptfs-wrap-passphrase "$wrapped"
printf "%s" "$password" | ecryptfs-insert-wrapped-passphrase-into-keyring "$wrapped"
response=`printf "%s" "$mountpass" | ecryptfs-add-passphrase --fnek -`
sig=`echo "$response" | grep "Inserted auth tok" | sed "s/^.*\[//" | sed "s/\].*$//"`
echo "$sig" > "$sigpath"

chmod 600 "$user_ecrypt_path/.ecryptfs/Private.sig"
chmod 600 "$user_ecrypt_path/.ecryptfs/Private.mnt"
chmod 600 "$user_ecrypt_path/.ecryptfs/wrapped-passphrase"
chmod 644 "$user_ecrypt_path/.ecryptfs/auto-mount"
chmod 644 "$user_ecrypt_path/.ecryptfs/auto-umount"

keyctl clear @u
