#!/bin/ash

username=$1
password=$2
path="$3"

sigpath=$(printf "%s%s.sig" "$path" "$username")

mountpass=$(openssl rand -base64 32)

printf "%s\n%s" "$mountpass" "$password" | ecryptfs-wrap-passphrase "${path}${username}"
printf "%s" "$password" | ecryptfs-insert-wrapped-passphrase-into-keyring "${path}${username}"
response=`printf "%s" "$mountpass" | ecryptfs-add-passphrase --fnek -`
sig=`echo "$response" | grep "Inserted auth tok" | sed "s/^.*\[//" | sed "s/\].*$//"`
echo "$sig" > "$sigpath"

PATHPASSSIG="/opt/ecryptfs/" # Path to where the pass and sigs are stored
PATHECRYPT="/home/.ecryptfs/" # Path to where the .Private and .ecryptfs of users will be stored

mkdir -p "${PATHECRYPT}${username}/"
mkdir -m 700 "${PATHECRYPT}${username}/.Private"
mkdir -m 700 "${PATHECRYPT}${username}/.ecryptfs"

touch "${PATHECRYPT}${username}/.ecryptfs/auto-mount"
touch "${PATHECRYPT}${username}/.ecryptfs/auto-umount"
echo "/home/${username}" > "${PATHECRYPT}${username}/.ecryptfs/Private.mnt"
cp "${PATHPASSSIG}${username}.sig" "${PATHECRYPT}${username}/.ecryptfs/Private.sig"
cp "${PATHPASSSIG}${username}" "${PATHECRYPT}${username}/.ecryptfs/wrapped-passphrase"

chmod 600 "${PATHECRYPT}${username}/.ecryptfs/Private.sig"
chmod 600 "${PATHECRYPT}${username}/.ecryptfs/Private.mnt"
chmod 600 "${PATHECRYPT}${username}/.ecryptfs/wrapped-passphrase"
chmod 644 "${PATHECRYPT}${username}/.ecryptfs/auto-mount"
chmod 644 "${PATHECRYPT}${username}/.ecryptfs/auto-umount"
chown -R "$username:$username" "${PATHECRYPT}${username}"

rm -rf "/home/$username"
mkdir "/home/$username"
chmod 700 "/home/$username"
chown "$username:$username" "/home/$username"

ln -s "${PATHECRYPT}${username}/.ecryptfs/" "/home/$username/"
ln -s "${PATHECRYPT}${username}/.Private/" "/home/$username/"
ln -s "${PATHPASSSIG}README.txt" "/home/$username/README.txt"
chown -h "$username:$username" "/home/$username/README.txt"
chown -h "$username:$username" "/home/$username/.ecryptfs"
chown -h "$username:$username" "/home/$username/.Private"
