#!/bin/ash

#Check if the user running this code has permissoes to run it
if [ "$(/opt/openslx/bin/id -u)" != "0" ]; then
    echo $0": Você não possue as permissoes necessárias para realizar essa operação"
    exit 1
else
    echo $0": Você tem permissoes para executar esse programa"
fi

if [ -z "$1"  ];then
    . /opt/openslx/config || { echo "Could not source config!"; exit 23; }
else
    . "$1" || { echo "Could not source custom config!"; exit 23; }
fi

for file in passwd group shadow; do
    if [ -e /home/openslx/localaccounts/bak/$file ]; then
        echo $0": Copying "$file" from backup"
        cp /home/openslx/localaccounts/bak/$file /etc/$file
    fi
done

unset IFS
set $SLX_USERS

# parse config variable
while (( [ $# -gt 0 ] )); do
    # get the respective line for passwd, shadow and group
    # shift advances the line $1 refers to
    # since it doesn't check if there are 3 lines to parse,
    # the program may misbehave in an insecure way
    # if config file is corrupted or invalid.
    passwdf=$(echo $1 | cut -d'=' -f2)
    shift
    shadowf=$(echo $1 | cut -d'=' -f2)
    shift
    groupf=$(echo $1 | cut -d'=' -f2)
    shift

    # parse each line (stored on variables by the code above) for needed info
    username=$( echo $passwdf | cut -d':' -f1 )
    uID=$( echo $passwdf | cut -d':' -f3 )
    globalID=$( echo $uID | grep -e "^3....$" )

    groupname=$( echo $groupf | cut -d':' -f1 )
    gID=$( echo $groupf | cut -d':' -f3 )
    globalGID=$( echo $gID | grep -e "^3....$" )

    # global users have to belong to a group with the same name
    if [ "$username" = "$groupname" ]; then
        # checks if the user's id is in the correct range
        # if the user is not global globalID and globalGID will be empty
        # because grep will not find anything
        if [ -n "$globalID" ] && [ -n "$globalGID" ]; then
            /opt/openslx/scripts/adduser.sh "$passwdf" "$groupf" "$shadowf" "global"
        fi
    fi
done

#add groups to global users
for line in $SLX_GROUPS; do
    echo $0": "$line
    IFS=,
    set $line
    username=$1
    shift
    while (( [ $# -gt 0 ] )); do
        echo $0:"addusertogroup "$username" "$1
        temp=$(mktemp)
        firstuser=$( cat /etc/group | grep -e "^$1:.*:.*:$" )
        if [ -n "$firstuser" ]; then
            sed -e "s/^$1.*/&$username/" /etc/group  > $temp
        else
            sed -e "s/^$1.*/&,$username/" /etc/group  > $temp
        fi
        cp $temp /etc/group
        chown root:root /etc/group
        chmod 644 /etc/group
        rm $temp
        shift
    done
    unset IFS
done

# instanciates the configuration file
if [ ! -e /home/openslx/localaccounts/.config ]; then
    echo $0": Configuration of local users doesn't exist, creating a blank one"
    > /home/openslx/localaccounts/.config
fi
unset IFS
users=$(cat /home/openslx/localaccounts/.config);
set $users

# parse config file until EOF
while (( [ $# -gt 0 ] )); do
    # get the respective line for passwd, shadow and group
    # shift advances the line $1 refers to
    # since it doesn't check if there are 3 lines to parse,
    # the program may misbehave in an insecure way
    # if config file is corrupted or invalid.
    passwdf=$(echo $1 | cut -d'=' -f2)
    shift
    shadowf=$(echo $1 | cut -d'=' -f2)
    shift
    groupf=$(echo $1 | cut -d'=' -f2)
    shift

    # parse each line (stored on variables by the code above) for needed info
    username=$( echo $passwdf | cut -d':' -f1 )
    uID=$( echo $passwdf | cut -d':' -f3 )
    localID=$( echo $uID | grep -e "^2....$" -e "^1....$" )

    groupname=$( echo $groupf | cut -d':' -f1 )
    gID=$( echo $groupf | cut -d':' -f3 )
    localGID=$( echo $gID | grep -e "^2....$" -e "^1....$" )

    # local users have to belong to a group with the same name
    if [ "$username" = "$groupname" ]; then
        # checks if the user's id is in the correct range
        # if the user is not local localID and localGID will be empty
        # because grep will not find anything
        if [ -n "$localID" ] && [ -n "$localGID" ]; then
            /opt/openslx/scripts/adduser.sh "$passwdf" "$groupf" "$shadowf"
        fi
    fi
done


#Rebuild pendrive users
for pen in $(ls -tr /dev/disk/by-id/usb*); do
     dev=$(readlink -f "$pen")
     dev=$(echo "$dev" | cut -d'/' -f3)

     #call insert data
     /opt/openslx/scripts/local-accounts_insert-data.sh "$dev"
     #echo "$dev"
done
