#!/bin/bash

#if vfat, umount and remount everything with the users that is logging

#set -x
#echo $USER > /var/log/logfile

if ( [ ! -e /home/openslx/usb_users/$USER ] ); then
    exit 0;
fi

user_drive=$(cat /home/openslx/usb_users/$USER)

user_drive_type=$(cat /proc/self/mountinfo | grep "$user_drive" | head -n1 | cut -d' ' -f9)

if ( [ "$user_drive_type" = "vfat" ] ); then
    echo $0": user drive type is vfat"
	uid=$(cat /etc/passwd | grep -e "^$USER:" | cut -d':' -f3)
	guid=$(cat /etc/passwd | grep -e "^$USER:" | cut -d':' -f4)

    users="";
    #umount everything
    IFS=$'\n'
    for i in $(cat /proc/self/mountinfo | grep $user_drive); do
        root_of_mount=$(echo $i | cut -d' ' -f4);

        if ( [ "$root_of_mount" = "/" ] ); then
            #this is the drive
            #saves mount point to remount in the correct place
            drive_mount_point=$(echo $i | cut -d' ' -f5)
        else
            #this is a user
            #save user_names that are mounted to make binding easier after
            user_name=$(echo $i | cut -d' ' -f4 | rev | cut -d'/' -f1 | rev )
            users=$(echo "$users $user_name")
            #check if there is something mounted in this user home( $user_name )
            #if so, umount it
        fi

        mount_point=$(echo $i | cut -d' ' -f5)
        #maybe umount -f -l
        umount -f -l $mount_point
    done
    unset IFS


    #mount with correct uid
    mount -t vfat $user_drive $drive_mount_point -o uid=$uid,gid=$guid

    #rebind stuff
    for i in $users; do
        mount --bind ${drive_mount_point}/Openslx/$i /home/$i
    done

    #significatlçy improves speed and leaves the user pendrive without useless files
    #mount --bind /dev/shm /home/$USER/.cache
fi

if ( [ "$user_drive_type" = "ext4" ] ); then
    echo $0": user drive type is ext4"
    #do encryption
fi


