#!/bin/sh

remove (){

#exec 1<&-
#exec 2<&-
#exec 1<>/var/log/local-accounts
#exec 2>&1
#set -x

    user_drive="/dev/$1"

    #check if this is a openslx drive
    mountpath=$(mount | sed 's/ type.*//' | grep -w $dev | cut -d' ' -f3- | head -n1)
    if [ -e "$mountpath/Openslx/.config" ]; then
        echo "$0: /dev/$dev is an openslx ready drive"
    else
        echo "$0: /dev/$dev is not ready to be used as an openslx drive"
        exit 2 # stops openslx users_pendrive execution for this dev
    fi

    #umount everything
    IFS_bckp=$IFS
    IFS=$'\n'
    for i in $(mount | grep $user_drive | sed 's/ type.*//' | cut -d' ' -f3); do
        umount -f -l $i
    done
    IFS=$IFS_bckp

    ##Rebuild passwd,shadow,group
    rm -rf /home/openslx/usb_users/*
    rm /etc/passwd
    rm /etc/shadow
    rm /etc/group

    /opt/openslx/scripts/local-accounts.sh
}

remove $1 &
exit;
