#!/bin/ash

TEMP_HOME_DIR="$HOME"
PERSISTENT_HOME_DIR="$HOME/PERSISTENT"

if [ -d "$PERSISTENT_HOME_DIR" ]; then

	# Persistent home was mounted, take care of some conveinience
	# Dirs
	for file in .vim .mozilla .thunderbird .config/chromium .config/htop .config/openslx .config/xfce4 .eclipse; do
		[ -e "$TEMP_HOME_DIR/$file" ] && break
		if [ "x$(dirname "$file")" != "x." ]; then
			mkdir -p "$TEMP_HOME_DIR/$(dirname "$file")"
		fi
		if [ ! -d "$PERSISTENT_HOME_DIR/$file" ]; then
			mkdir -p "$PERSISTENT_HOME_DIR/$file"
		fi
		ln -s "$PERSISTENT_HOME_DIR/$file" "$TEMP_HOME_DIR/$file"
	done
	# Files
	for file in .bashrc .profile .vimrc .gitconfig; do
		[ -e "$TEMP_HOME_DIR/$file" ] && break
		if [ "x$(dirname "$file")" != "x." ]; then
			mkdir -p "$TEMP_HOME_DIR/$(dirname "$file")"
		fi
		if [ ! -e "$PERSISTENT_HOME_DIR/$file" ]; then
			touch "$PERSISTENT_HOME_DIR/$file"
		fi
		ln -s "$PERSISTENT_HOME_DIR/$file" "$TEMP_HOME_DIR/$file"
	done
	# Check if user has autostart script and run it (so they can create more symlinks etc.)
	if [ -x "$PERSISTENT_HOME_DIR/AUTOSTART" ]; then
		if cd "$TEMP_HOME_DIR"; then
			"$PERSISTENT_HOME_DIR/AUTOSTART"
			cd - >/dev/null 2>&1
		fi
	fi

fi

