import { deleteObject, getFile, putFile } from "@/services/s3.service";
import { Hono } from "hono";


export const s3Routes = new Hono()

    //rota de enviar blob para o s3
    //id_ resource é o id do recurso
    //faz o upload do conteudo do recurso
    .post('/upload/resource/:id_resource',
        async (ctx) => {
            const id = ctx.req.param('id_resource');

            const formData = await ctx.req.formData();
            const fileBlob = formData.get('file');



            if (!fileBlob || !(fileBlob instanceof Blob)) {
                return ctx.json({ message: 'No files sent or invalid format' }, 400)
            }

            // Obtém o tamanho do arquivo em bytes
            const fileSize = fileBlob.size;
            const maxSize = 5 * 1024 * 1024 * 1024; // 5GB em bytes

            if (fileSize > maxSize) {
                return ctx.json({
                    message: `O arquivo excede o limite de 5GB (${(fileSize / (1024 * 1024 * 1024)).toFixed(2)} GB).`,
                    status: 'error'
                }, 400);
            }

            try {
                const result = await putFile(fileBlob, id, "resource")
                return ctx.json({
                    message: 'Arquivo enviado com sucesso!',
                    fileId: id,
                    status: 'success',
                    details: result
                }, 200);
            } catch (error) {
                console.error('Erro ao fazer upload do arquivo:', error);
                return ctx.json({
                    message: 'Erro interno ao enviar o arquivo. Tente novamente mais tarde.',
                    status: 'error'
                }, 500);
            }
        }
    )

    // envio de fotos de thumbnail do recurso
    .post('/upload/thumbnail/resource/:id_resource',
        async (ctx) => {
            const id = ctx.req.param('id_resource');

            const formData = await ctx.req.formData();
            const fileBlob = formData.get('file');


            if (!fileBlob || !(fileBlob instanceof Blob)) {
                return ctx.json({ message: 'No files sent or invalid format' }, 400)
            }

            // Obtém o tamanho do arquivo em bytes
            const fileSize = fileBlob.size;
            const maxSize = 1 * 1024 * 1024; // 1MB em bytes

            if (fileSize > maxSize) {
                return ctx.json({
                    message: `A thumbnail do recurso excede o limite de 1MB (${(fileSize / (1024)).toFixed(2)} KB).`,
                    status: 'error'
                }, 400);
            }


            try {
                const result = await putFile(fileBlob, id, "thumbnail/resource")
                return ctx.json({
                    message: 'Arquivo enviado com sucesso!',
                    fileId: id,
                    status: 'success',
                    details: result
                }, 200);
            } catch (error) {
                console.error('Erro ao fazer upload do arquivo:', error);
                return ctx.json({
                    message: 'Erro interno ao enviar o arquivo. Tente novamente mais tarde.',
                    status: 'error'
                }, 500);
            }
        }
    )


    // envio de fotos de thumbnail da coleção
    .post('/upload/thumbnail/collection/:id_collection',
        async (ctx) => {
            const id = ctx.req.param('id_collection');

            const formData = await ctx.req.formData();
            const fileBlob = formData.get('file');


            if (!fileBlob || !(fileBlob instanceof Blob)) {
                return ctx.json({ message: 'No files sent or invalid format' }, 400)
            }

            // Obtém o tamanho do arquivo em bytes
            const fileSize = fileBlob.size;
            const maxSize = 1 * 1024 * 1024; // 1MB em bytes

            if (fileSize > maxSize) {
                return ctx.json({
                    message: `A thumbnail da collection excede o limite de 1MB (${(fileSize / (1024)).toFixed(2)} KB).`,
                    status: 'error'
                }, 400);
            }


            try {
                const result = await putFile(fileBlob, id, "thumbnail/collection")
                return ctx.json({
                    message: 'Arquivo enviado com sucesso!',
                    fileId: id,
                    status: 'success',
                    details: result
                }, 200);
            } catch (error) {
                console.error('Erro ao fazer upload do arquivo:', error);
                return ctx.json({
                    message: 'Erro interno ao enviar o arquivo. Tente novamente mais tarde.',
                    status: 'error'
                }, 500);
            }
        }
    )


    // envio de fotos de thumbnail da coleção
    .post('/upload/avatar/:id_avatar',
        async (ctx) => {
            const id = ctx.req.param('id_avatar');

            const formData = await ctx.req.formData();
            const fileBlob = formData.get('file');


            if (!fileBlob || !(fileBlob instanceof Blob)) {
                return ctx.json({ message: 'No files sent or invalid format' }, 400)
            }

            // Obtém o tamanho do arquivo em bytes
            const fileSize = fileBlob.size;
            const maxSize = 5 * 1024 * 1024; // 5MB em bytes

            if (fileSize > maxSize) {
                return ctx.json({
                    message: `O avatar excede o limite de 5MB (${(fileSize / (1024)).toFixed(2)} KB).`,
                    status: 'error'
                }, 400);
            }


            try {
                const result = await putFile(fileBlob, id, "avatar")
                return ctx.json({
                    message: 'Arquivo enviado com sucesso!',
                    fileId: id,
                    status: 'success',
                    details: result
                }, 200);
            } catch (error) {
                console.error('Erro ao fazer upload do arquivo:', error);
                return ctx.json({
                    message: 'Erro interno ao enviar o arquivo. Tente novamente mais tarde.',
                    status: 'error'
                }, 500);
            }
        }
    )

    .post("/delete/resource/:id", async (c) => {
        const id = c.req.param("id");

        try {
            const response = await deleteObject(`resource/${id}`);
            return c.json(response); 
        } catch (error) {
            return c.json({ error: "Erro ao deletar objeto do S3." }, 500);
        }
    })

    .post("/delete/avatar/:id", async (c) => {
        const id = c.req.param("id");

        try {
            const response = await deleteObject(`avatar/${id}`);
            return c.json(response); 
        } catch (error) {
            return c.json({ error: "Erro ao deletar objeto do S3." }, 500);
        }
    })

    .post("/delete/thumbnail/resource/:id", async (c) => {
        const id = c.req.param("id");

        try {
            const response = await deleteObject(`thumbnail/resource/${id}`);
            return c.json(response); 
        } catch (error) {
            return c.json({ error: "Erro ao deletar objeto do S3." }, 500);
        }
    })

    .post("/delete/thumbnail/collection/:id", async (c) => {
        const id = c.req.param("id");

        try {
            const response = await deleteObject(`thumbnail/collection/${id}`);
            return c.json(response); 
        } catch (error) {
            return c.json({ error: "Erro ao deletar objeto do S3." }, 500);
        }
    })



    .get("get/resource/:id",
        async (ctx) => {

            const id = ctx.req.param("id");

            try {
                // Busca o arquivo no S3 com a chave "resource/id"
                const response = await getFile(`resource/${id}`);

                if (!response || !response.Body) {
                    return ctx.json({ message: "Arquivo não encontrado" }, 404);
                }

                // O corpo da resposta é o arquivo, e seu tipo de conteúdo pode ser acessado diretamente
                const fileData = await response.Body.transformToByteArray()// Converte o conteúdo do corpo para ArrayBuffer ou outro formato adequado

                return new Response(fileData, {
                    status: 200,
                    headers: {
                        "Content-Type": response.ContentType || "application/octet-stream", // Obtém o tipo de conteúdo diretamente da resposta
                    }
                });

            } catch (error) {
                console.error("Erro ao buscar arquivo do S3:", error);
                return ctx.json(
                    { message: "Erro interno ao buscar o arquivo" },
                    500
                );
            }
        }
    )

    .get("get/thumbnail/resource/:id",
        async (ctx) => {

            const id = ctx.req.param("id");

            try {
                // Busca o arquivo no S3 com a chave "resource/id"
                const response = await getFile(`thumbnail/resource/${id}`);

                if (!response || !response.Body) {
                    return ctx.json({ message: "Arquivo não encontrado" }, 404);
                }

                // O corpo da resposta é o arquivo, e seu tipo de conteúdo pode ser acessado diretamente
                const fileData = await response.Body.transformToByteArray()// Converte o conteúdo do corpo para ArrayBuffer ou outro formato adequado

                return new Response(fileData, {
                    status: 200,
                    headers: {
                        "Content-Type": response.ContentType || "application/octet-stream", // Obtém o tipo de conteúdo diretamente da resposta
                    }
                });

            } catch (error) {
                console.error("Erro ao buscar arquivo do S3:", error);
                return ctx.json(
                    { message: "Erro interno ao buscar o arquivo" },
                    500
                );
            }
        }
    )



    .get("get/thumbnail/collection/:id",
        async (ctx) => {

            const id = ctx.req.param("id");

            try {
                // Busca o arquivo no S3 com a chave "resource/id"
                const response = await getFile(`thumbnail/collection/${id}`);

                if (!response || !response.Body) {
                    return ctx.json({ message: "Arquivo não encontrado" }, 404);
                }

                // O corpo da resposta é o arquivo, e seu tipo de conteúdo pode ser acessado diretamente
                const fileData = await response.Body.transformToByteArray()// Converte o conteúdo do corpo para ArrayBuffer ou outro formato adequado

                return new Response(fileData, {
                    status: 200,
                    headers: {
                        "Content-Type": response.ContentType || "application/octet-stream", // Obtém o tipo de conteúdo diretamente da resposta
                    }
                });

            } catch (error) {
                console.error("Erro ao buscar arquivo do S3:", error);
                return ctx.json(
                    { message: "Erro interno ao buscar o arquivo" },
                    500
                );
            }
        }
    )

    .get("get/avatar/:id",
        async (ctx) => {

            const id = ctx.req.param("id");

            try {
                // Busca o arquivo no S3 com a chave "resource/id"
                const response = await getFile(`avatar/${id}`);

                if (!response || !response.Body) {
                    return ctx.json({ message: "Arquivo não encontrado" }, 404);
                }

                // O corpo da resposta é o arquivo, e seu tipo de conteúdo pode ser acessado diretamente
                const fileData = await response.Body.transformToByteArray()// Converte o conteúdo do corpo para ArrayBuffer ou outro formato adequado

                return new Response(fileData, {
                    status: 200,
                    headers: {
                        "Content-Type": response.ContentType || "application/octet-stream", // Obtém o tipo de conteúdo diretamente da resposta
                    }
                });

            } catch (error) {
                console.error("Erro ao buscar arquivo do S3:", error);
                return ctx.json(
                    { message: "Erro interno ao buscar o arquivo" },
                    500
                );
            }
        }
    )


