import { honoWithJwt } from "..";
import Container from "typedi";
import { zValidator } from "@hono/zod-validator";
import { createApexError, HttpStatus } from "@/services/error.service";
import { UserInstitutionRelationService } from "@/services/user-institution.relation.service";
import { userInstitutionRelationSchemas } from "@/db/relations/user-institution.relation";
import { z } from "zod";
import { UserService } from "@/services/user.service";
import { userSchemas, type UserProfile } from "@/db/schema/user.schema";
import { InstitutionService } from "@/services/institution.service";
import { institutionSchemas, type InstitutionModel } from "@/db/schema/institution.schema";

const service = Container.get(UserInstitutionRelationService)
const userService = Container.get(UserService)
const institutionService = Container.get(InstitutionService)

export const userInstitutionRouter = honoWithJwt()
  .post('/assign', zValidator('json', userInstitutionRelationSchemas.input),
    async (c) => {
      try{
        const input = await c.req.valid('json')
        let user = await userService.findById(input.user_id)
        let institution = await institutionService.findById(input.institution_id) //tinha que ver questão de um usuario sem ser admin poder criar um admin
        let alreadyInstitution = await service.findByUserInstitution(input) != 0        
        if(user == null || institution == null || alreadyInstitution){
          throw new Error()
        }
        console.log('oiiii')

        const user_institution = userInstitutionRelationSchemas.dto.parse(
          await service.create(input)
        )
        user.institution = institution.name
        await userService.update(user)
        return c.json({ user_institution })
      } catch (e) {
        return c.json(
          createApexError({
            status: 'error',
            message: 'could not create user stats',
            code: HttpStatus.BAD_REQUEST,
            path: c.req.routePath,
            suggestion: 'check the input and try again',
          }),
          HttpStatus.BAD_REQUEST
        )
      }
  })
  .get('/institutions/user/:user_id', async (c) =>{ 
    try{
      const user_id = +c.req.param('user_id')
      const institutions_by_user = z.array(userInstitutionRelationSchemas.model).parse(await service.findByUserId(user_id))
      var institutions: InstitutionModel[] = []

      for(var element of institutions_by_user){
        let institution = await institutionService.findById(element.institution_id)
        if(institution != null)
          institutions.push(institutionSchemas.dto.parse(institution))
      }
      
      return c.json({ institutions })

    } catch(e){
      return c.notFound()
    }
  })
  .get('/users/institution/:institution_id', async (c) =>{
    try{
      const institution_id = +c.req.param('institution_id')
      const users_by_institution = z.array(userInstitutionRelationSchemas.model).parse(await service.findByInstitutionId(institution_id))
      
      var users: UserProfile[] = []

      for(var element of users_by_institution){
        let user = await userService.findById(element.user_id)
        if(user != null)
          users.push(userSchemas.userProfileSchema.parse(user))
      }
      
      
      return c.json({ users })

    } catch(e){
      return c.notFound()
    }
  })
  .post('/revoke',
    zValidator('json', userInstitutionRelationSchemas.input),
    async (c) =>{
      try{
        const input = await c.req.valid('json')
        const userInstitution_id = await service.findByUserInstitution(input)        
        const ret = userInstitutionRelationSchemas.dto.parse(
          await service.delete(userInstitution_id)
        )
        return c.json(ret)
      } catch (e){
        return c.json(
          createApexError({
            status: 'error',
            message: 'could delete user stats',
            code: HttpStatus.BAD_REQUEST,
            path: c.req.routePath,
            suggestion: 'check the input and try again',
          }),
          HttpStatus.BAD_REQUEST
        )
      }
  })