import React, {useState} from 'react'
import styled from 'styled-components'
import Rating from '@material-ui/lab/Rating';
import StarBorderIcon from '@material-ui/icons/StarBorder';
import StarIcon from '@material-ui/icons/Star';
import TextField from "@material-ui/core/TextField";
import { Button } from '@material-ui/core';
import axios from 'axios'
import {apiUrl} from '../../env';

export default function CommentForm (props) {
    const [rating, setRating] = useState({
        error : true,
        value : 0
    })
    const [comment, setComment] = useState({
        error : false,
        value : ''
    })

    const handleChange = (e) => {
        const userInput = e.target.value
        const flag = (userInput.length === 0 ? true : false);
        setComment({...comment, error : flag, value : userInput})
    }

    const [attemptedSubmit, setAttempt] = useState(false)

    const handleSubmit = (e) => {
        e.preventDefault()
        const finalRating = rating
        const finalComment = comment


        if (!(finalRating.error || finalComment.error)) {
            let config = {
                headers : {
                    'Accept': 'application/json',
                    'Content-Type': 'application/json',
                    'Access-Token': sessionStorage.getItem('@portalmec/accessToken'),
                    'Client': sessionStorage.getItem('@portalmec/clientToken'),
                    'Uid': sessionStorage.getItem('@portalmec/uid'),
                }
            }
            let payload = {
                "review" : {
                    "description" : finalComment.value,
                    "review_ratings_attributes" : [
                        {
                            "rating_id" : 1,
                            "value" : finalRating.value
                        }
                    ]
                }
            }
            console.log(payload)
            axios.post( (`${apiUrl}/learning_objects/` + props.recursoId + '/reviews'), payload, config
        ).then((response) => {
            if ( response.headers['access-token'] ) {
                sessionStorage.setItem('@portalmec/accessToken', response.headers['access-token'])
            }
            console.log(response.data);
             props.handleSnackbar(1);
              props.rerenderCallback()},
        (error) => {console.log(error)})
        }
        else {
            setAttempt(true)
        }
    }

    return (
        <StyledForm onSubmit={handleSubmit}>
            <label htmlFor="avaliacao-estrelas" className="start-label">
                Este recurso foi útil?*
            </label>
            <div className="stars-container">
                <Rating
                  name="avaliacao-estrelas"
                  value={rating.value}
                  precision={0.5}
                  style={{color:"#ff9226"}}
                  onChange = {(e, newValue) => {setRating({...rating, error : newValue === null ? true : false, value : newValue})}}
                  emptyIcon={<StarIcon fontSize="inherit" style={{color : "#666"}} />}
                  getLabelText={(value) => {return(value + ' Estrela' + (value !== 1 ? 's' : ''))}}
                />
            </div>
            <div className="star-alert" style={attemptedSubmit ? {visibility : "visible"} : {visibility : "hidden" }}>Avalie se o recurso foi útil.</div>

            <span>
                <StyledTextField
                    value={comment.value}
                    multiline
                    rows="5"
                    error={comment.error}
                    label={"Escreva aqui a sua experiência com este Recurso"}
                    onChange={e => handleChange(e)}
                    required={true}
                    help = {comment.error ? 'Escreva aqui seu comentário sobre o Recurso.' : ''}
                />
            <OrangeButton type="submit">Publicar</OrangeButton>
                <div className="campos-obrigatorios">* Campos obrigatórios.</div>
            </span>
        </StyledForm>
    )
}

const OrangeButton = styled(Button)`
    color : rgba(255,255,255,0.87) !important;
    box-shadow : 0 2px 5px 0 rgba(0,0,0,.26) !important;
    font-weight : 600 !important;
    background-color : #ff7f00 !important;
`

const StyledTextField = styled(TextField)`
    .MuiInputBase-root {
        margin-bottom : 42px;
    }

    label.Mui-focused {
        color : rgb(255,127,0);
    }

    .MuiInput-underline::after {
        border-bottom: 2px solid rgb(255,127,0);
    }

    label.Mui-focused.Mui-error {
        color : red;
    }

    max-width: 80%;
    width : 80% !important;
    full-width : 80% !important;
`

const StyledForm = styled.form`
    display : flex;
    flex-direction : column;
    text-align : start;

    .start-label {
        font-size : 14px;
        max-width : 100%;
        display : inline-block;
        margin-bottom : 0;
        color : #a5a5a5;
        font-weight : 400;
    }

    .stars-container {
        padding-top : 10px;
        padding-bottom : 5px;
        display : flex;
        flex-direction : row;
        align-self : flex-start;
        margin-bottom : 5px;
        color : #a5a5a5;
    }

    .star-alert {
        color : #666;
        text-align : start;
    }

    .campos-obrigatorios {
        font-weight : 400;
        font-size : 12px;
        color :#a5a5a5;
    }
`
