/*Copyright (C) 2019 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana

This file is part of Plataforma Integrada MEC.

Plataforma Integrada MEC is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Plataforma Integrada MEC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with Plataforma Integrada MEC.  If not, see <http://www.gnu.org/licenses/>.*/

import React, {useState, useContext, useEffect} from 'react'
import {Store} from '../../Store.js'
import styled from 'styled-components'
import Grid from '@material-ui/core/Grid';
import { Button } from '@material-ui/core';
import ExitToAppIcon from '@material-ui/icons/ExitToApp';
import Comentarios from '../../img/comentarios.png'
import {apiUrl, apiDomain} from '../../env';
import CommentForm from './CommentForm.js'
import axios from 'axios'
import Comment from '../Comment.js'

export default function CommentsArea (props) {
    const {state} = useContext(Store)
    const [comentarios, setComentarios] = useState([])
    const [gambiarra, setState] = useState(0)
    const forceUpdate = () => {setState(gambiarra + 1)}

    useEffect( () => {
        axios.get( (`${apiUrl}/learning_objects/` + props.recursoId + '/reviews')
    ).then( (response) => {
        if ( response.headers['access-token'] ) {
            sessionStorage.setItem('@portalmec/accessToken', response.headers['access-token'])
        }
        console.log(response)
        setComentarios(response.data.sort((a, b) => a.updated_at > b.updated_at ? -1 : 1))
    }, (error) => {console.log(error)})
    }, [gambiarra])

    return (
        <Grid container spacing={2} style={{padding : "10px"}}>
            {
                (state.currentUser.id !== '') ?
                (
                    [
                        <Grid item xs={12} >
                            <GrayContainer>
                                <h3>Conte sua experiência com o Recurso</h3>
                                <Grid container style={{paddingTop : "20px"}}>
                                    <Grid item xs={2} style={{paddingLeft : "15px", paddingRight : "15px"}}>
                                        <img src={apiDomain + state.currentUser.userAvatar} className="minha-imagem" alt="user avatar"/>
                                    </Grid>
                                    <Grid item xs={10}>
                                        <CommentForm
                                            recursoId={props.recursoId}
                                            handleSnackbar={props.handleSnackbar}
                                            rerenderCallback={forceUpdate}
                                            />
                                    </Grid>
                                </Grid>
                            </GrayContainer>
                        </Grid>
                    ]
                )
                :
                (
                    [
                        <Grid item xs={12}>
                            <LogInToComment>
                                <span className="span-laranja">Você precisa entrar para comentar</span>
                                {/*adicionar funcionalidade ao botao de entrar*/}
                                <Button style={{textTransform : "uppercase", color : "#666", fontWeight : "700"}}>
                                     <ExitToAppIcon/>ENTRAR
                                 </Button>
                            </LogInToComment>
                        </Grid>
                    ]
                )
            }
            {
                comentarios.length !== 0 ?
                (
                    [
                            <ComentariosBox>
                                <h3>{comentarios.length} {comentarios.length != 1 ? 'Relatos' : 'Relato'} sobre o uso do Recurso</h3>
                                {
                                    comentarios.map( comentario =>
                                            <div className="comentario-template" key={comentario.id}>
                                                <Comment
                                                    authorID={comentario.user ? comentario.user.id : null}
                                                    authorAvatar={comentario.user ? comentario.user.avatar : null}
                                                    authorName={comentario.user ? comentario.user.name : null}
                                                    name={comentario.name}
                                                    rating={comentario.rating_average}
                                                    reviewRatings = {comentario.review_ratings}
                                                    description={comentario.description}
                                                    createdAt={comentario.created_at}
                                                    recurso={true}
                                                    reviewID={comentario.id}
                                                    objectID={props.recursoId}
                                                    rerenderCallback={forceUpdate}
                                                    handleSnackbar={props.handleSnackbar}
                                                    />
                                            </div>
                                    )
                                }
                            </ComentariosBox>
                    ]
                )
                :
                (
                    [
                        <Grid item xs={12}>
                            <LogInToComment>
                                <img src={Comentarios} />
                                <span className="span-laranja">Compartilhe sua experiência com a Rede!</span>
                                <AoRelatar>
                                    Ao relatar sua experiência de uso do Recurso você estará auxiliando professores de todo país.
                                </AoRelatar>
                            </LogInToComment>
                        </Grid>
                    ]
                )
            }
        </Grid>
    )
}


const ComentariosBox = styled.div`
    display : flex;
    flex-direction : column;
    padding : 20px;
    width : 100%;

    h3 {
        font-family: 'Roboto Light','Roboto Regular',Roboto;
        font-weight: 300;
        font-style: normal;
        color:#666;
        font-size: 1.857em;
        margin: 15px 2%;
        text-align : flex-start;
    }

    .comentario-template {
        padding : 20px 0;
        border-bottom : 1px solid #f4f4f4;
    }
`
const AoRelatar = styled.div`
    width : 70%;
    font-size : 20px;
    font-weight : 300;
    text-align : center;
    padding-bottom : 20px;
`

const LogInToComment = styled.div`
    display : flex;
    flex-direction : column;
    text-align : center;
    padding : 20px;
    align-items : center;

    .span-laranja {
        font-size : 24px;
        font-weight : 700;
        padding-bottom : 5px;
        color : #ff7f00;
    }

    img {
        object-fit : contain !important;
        background-color : transparent !important;
    }
`

const GrayContainer = styled.div`
    background-color : #fafafa;
    font-weight : 400;
    display : flex;
    flex-direction : column;
    justify-content : space-between;
    padding-right : 15px;
    padding-left : 15px;
    padding-bottom : 20px;

    h3 {
        font-family : 'Roboto Light','Roboto Regular',Roboto;
        font-weight: 300;
        font-style: normal;
        color: #666;
        font-size: 1.857em;
        margin-bottom : 10px;
        margin-left : 2%;
        margin-top : 2%;
    }

    .minha-imagem {
        height: 60px;
        width: 60px;
        border-radius: 50%;
        margin-left: 2%;
        margin-top: 5%;
    }
    img {
        vertical-align :middle;
    }
`
