import React, {useState, useContext} from 'react'
import {Store} from '../../Store.js'
import styled from 'styled-components'
import Grid from '@material-ui/core/Grid';
import { Button } from '@material-ui/core';
import ErrorIcon from '@material-ui/icons/Error';
import ShareIcon from '@material-ui/icons/Share';
import FolderIcon from '@material-ui/icons/Folder';
import GetAppIcon from '@material-ui/icons/GetApp';
import CallMadeIcon from '@material-ui/icons/CallMade';
import {Link} from 'react-router-dom'
import ReportModal from '../ReportModal.js'
import ReportRecursoForm from '../ReportRecursoForm.js'
import ShareModal from '../ShareModal.js'

export default function Footer (props) {
    const {state} = useContext(Store)
    const enableDownload = () => {
        const url = props.downloadableLink
        window.open(url, '_blank');
        props.handleSnackbar(0)
    }

    const [reportOpen, toggleReport] = useState(false)
    const [shareOpen, toggleShare] = useState(false)

    return (
        <React.Fragment>
            <ReportModal open={reportOpen} handleClose={() => {toggleReport(false)}}
                form="recurso"
                complainableId={props.recursoId}
                complainableType={"LearningObject"}
                />
            <ShareModal open={shareOpen} handleClose={() => {toggleShare(false)}}
                thumb={props.thumb} title={props.title} link={props.link}
                />

            <OpcoesDiv>
                <StyledGrid container>

                    {/*Botao Reportar*/}
                    <Grid item xs={3}>
                        <ButtonGrey onClick={state.currentUser.id === '' ? () => console.log('abrir login modal') : () => toggleReport(true)}>
                            <span className="button-text">
                                <ErrorIcon className="icon"/> Reportar abuso ou erro
                            </span>
                        </ButtonGrey>
                    </Grid>

                    {/*Botao Compartilhar*/}
                    <Grid item xs={3}>
                        <ButtonGrey onClick={state.currentUser.id === '' ? () => console.log('abrir login modal') : () => toggleShare(true)}>
                            <span className="button-text">
                                <ShareIcon className="icon"/> Compartilhar
                            </span>
                        </ButtonGrey>
                    </Grid>

                    <Grid item xs={3}>
                        <ButtonGrey>
                            <span className="button-text">
                                <FolderIcon className="icon"/>Guardar
                            </span>
                        </ButtonGrey>
                    </Grid>

                    <Grid item xs={3} style={{justifyContent : "right !important"}}>
                        <ButtonOrange onClick={() => {enableDownload()}}>
                            <span className="text">
                                <GetAppIcon className="icon"/> Baixar Recurso
                            </span>
                        </ButtonOrange>
                    </Grid>

                </StyledGrid>
            </OpcoesDiv>
        </React.Fragment>
    )
}

const OpcoesDiv = styled.div`
    display : flex;
    align-items : center;
    height : 65px;
    background-color : #fafafa;
`

const StyledGrid = styled(Grid)`
    padding-right : 15px;
    padding-left : 15px;

    .MuiGrid-item {
        padding-right : 15px;
        padding-left : 15px;
        display : flex;
        justify-content : center;
    }
`

const ButtonGrey = styled(Button)`
    &:hover {
        background-color : rgba(158,158,158,0.2) !important;
    }
    background-color : transparent !important;
    color : #666 !important;
    text-decoration : none !important;
    outline : none !important;
    text-align : center !important;

    .icon {
        vertical-align : middle !important;
        font-weight : normal !important;
        font-style : normal !important;
        font-size : 24px !important;
        line-height : 1 !important;
        letter-spacing : normal !important;
        text-transform : none !important;
        display : inline-block !important;
        white-space : nowrap !important;
        word-wrap : normal !important;
        direction : ltr !important;
        padding-right : 2px;
    }

    .button-text {
        cursor : pointer;
        line-height : 36px;
        text-align : center;
        color : currentColor;
        white-space : nowrap;
        text-transform : uppercase;
        font-weight : 600;
        font-size : 14px;
        font-style : inherit;
        font-variant : inherit;
    }
`

const ButtonOrange = styled(Button)`
    box-shadow : 0 2px 5px 0 rgba(0,0,0,.26) !important;
    background-color : #ff7f00 !important;
    color : #fff !important;
    text-decoration : none !important;
    text-transform : uppercase !important;
    outline : none !important;
    text-align : center !important;
    max-height : 36px;
    margin-top : 5px !important;

    .icon {
        vertical-align : middle !important;
        font-weight : normal !important;
        font-style : normal !important;
        font-size : 24px !important;
        line-height : 1 !important;
        letter-spacing : normal !important;
        text-transform : none !important;
        display : inline-block !important;
        white-space : nowrap !important;
        word-wrap : normal !important;
        direction : ltr !important;
        padding-right : 2px;
    }

    .text {
        font-size : 14px;
        font-weight : 600;
    }
`
