/*Copyright (C) 2019 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana

This file is part of Plataforma Integrada MEC.

Plataforma Integrada MEC is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Plataforma Integrada MEC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with Plataforma Integrada MEC.  If not, see <http://www.gnu.org/licenses/>.*/

import React, {useContext, useState, useEffect} from 'react'
import {Store} from '../../Store'
import styled from 'styled-components'
import Grid from '@material-ui/core/Grid';
import {Link} from 'react-router-dom'
import {NoIcon} from '../ContactButtons/FollowButton.js'
import MoreVertIcon from '@material-ui/icons/MoreVert';
import Collapse from '@material-ui/core/Collapse';
import SdCardIcon from '@material-ui/icons/SdCard';
import TranslateIcon from '@material-ui/icons/Translate';
import InsertDriveFileIcon from '@material-ui/icons/InsertDriveFile';
import ExpandMoreIcon from '@material-ui/icons/ExpandMore';
import ExpandLessIcon from '@material-ui/icons/ExpandLess';
import DateRangeIcon from '@material-ui/icons/DateRange';
import UpdateIcon from '@material-ui/icons/Update';
import AssignmentIcon from '@material-ui/icons/Assignment';
import License from '../../img/cc_license.png'

function AdditionalInfoItem (props) {
    return (
        <span className="meta-objeto">
            {props.icon}
            <span>{props.label}</span>
            {props.value}
        </span>
    )
}

export default function Sobre (props) {
    const {state} = useContext(Store)

    const [collapsed, setCollapsed] = useState(false)
    const toggleCollapsed = () => {setCollapsed(!collapsed)};

    var moment = require('moment')

    const [additionalInfo, setAdditionalInfo] = useState()

    useEffect(() => {
        let aux = []
        if (props.attachments[0]){
            aux.push(<AdditionalInfoItem
                icon={<SdCardIcon/>}
                label={'Tamanho: '}
                value={(props.attachments[0].size / 1000000).toFixed(2) + ' Mb'}
                />)
        }
        props.language.map( (lang) =>
            aux.push(<AdditionalInfoItem
                icon={<TranslateIcon/>}
                label={'Idioma: '}
                value={lang.name}
                key={lang.id}
                />
        ))
        if (props.mimeType){
            aux.push(<AdditionalInfoItem
                icon={<InsertDriveFileIcon/>}
                label={'Formato: '}
                value={props.mimeType}
                />)
        }
        if (props.createdAt) {
            aux.push(<AdditionalInfoItem
                icon={<DateRangeIcon/>}
                label={'Data de Envio: '}
                value={moment(props.createdAt).format("DD/MM/YYYY")}
                />)
        }
        if (props.updatedAt) {
            aux.push(<AdditionalInfoItem
                icon={<UpdateIcon/>}
                label={'Modificado em: '}
                value={moment(props.createdAt).format("DD/MM/YYYY")}
                />)
        }
        if (props.license) {
            aux.push(<AdditionalInfoItem
                icon={<AssignmentIcon/>}
                label={'Tipo de licença: '}
                value={
                    <div className="license-link">
                        <a href={props.license.url}>
                            <img src={License}/>
                        </a>
                        <p>
                            {props.license.name}<br/>4.0 Internacional
                        </p>
                    </div>
                }/>)
        }
        else {
            aux.push(<AdditionalInfoItem
                icon={<AssignmentIcon/>}
                label={'Tipo de licença: '}
                value={
                    <div className="license-link">
                        <p>
                            Informação não disponível.
                        </p>
                    </div>
                }/>)
        }
        setAdditionalInfo(aux)
    }, [])

    return (
        <Grid container style={{paddingRight : "15px", paddingLeft : "15px"}}>

            <Grid item xs={9} style={{paddingRight : "15px"}}>
                <Collapse in={collapsed} collapsedHeight={338}>
                    <SobreDiv>
                        <div className="titulo">
                            Sobre o Recurso
                        </div>

                        <div className="sobre-conteudo">
                            <div className="tags-container">
                                {
                                    props.tags.map( (tag) =>
                                        <span key={tag.id}>{tag.name}</span>
                                    )
                                }
                            </div>
                            <div className="conteudo">
                                <p className="descricao-objeto">{props.description}</p>
                                {
                                    props.author &&
                                    <p className="autoria">
                                        <b>Autoria: </b>{props.author}
                                    </p>
                                }
                            </div>
                        </div>

                        <div className="titulo">
                            Informações Adicionais
                        </div>

                        {additionalInfo}

                    </SobreDiv>
                </Collapse>
            </Grid>

            <Grid item xs={3}>
                <MetasObjeto>
                    <div className="enviado-por">
                        Enviado por:
                    </div>


                    <div className="foto-autor">
                        <Link to={"/usuario-publico/" + props.id}>
                            <img src={props.avatar}/>
                        </Link>
                    </div>

                    <div className="nome-autor">
                        <Link to={"/usuario-publico/" + props.id} style={{textDecoration : "none"}}>
                            <span className="span-st">{props.publisher}</span>
                        </Link>
                    </div>

                    <div style={{paddingTop : "0.75em"}}>
                    {
                        (props.id != state.currentUser.id) &&
                        <>
                        <NoIcon/>
                        <MoreVertIcon style={{verticalAlign : "middle"}}/>
                        </>
                    }
                    </div>
                </MetasObjeto>
            </Grid>

            <Grid item xs={12} style={{paddingTop : "15px"}}>
                <CollapseControl onClick={() => {toggleCollapsed()}}>
                    {
                        collapsed ?
                        (
                            [
                                <React.Fragment>
                                    <span>VER MENOS</span>
                                    <ExpandLessIcon/>
                                </React.Fragment>
                            ]
                        )
                        :
                        (
                            [
                                <React.Fragment>
                                    <span>VER MAIS</span>
                                    <ExpandMoreIcon/>
                                </React.Fragment>
                            ]
                        )
                    }
                </CollapseControl>
            </Grid>
        </Grid>
    )
}

const CollapseControl = styled.div`
    display : flex;
    justify-content : center;
    align-content : center;
    align-items : center;
    height : 50px;
    border-top : 1px solid #e5e5e5;
    color : #666;
    font-weight : 700;
    cursor : pointer;

    .MuiSvgIcon-root {
        vertical-align : middle
    }

    span {
        text-transform : uppercase;
        font-size : 14px;
    }
`

const SobreDiv = styled.div`
    padding-left : 3% !important;
    padding-top : 3% !important;
    .titulo {
        margin-top : 2% !important;
        margin : 0;
        margin-bottom : 10px;
        font-family : 'Roboto Light','Roboto Regular',Roboto;
        font-weight : 300;
        font-style : normal;
        color : #666;
        font-size : 1.857em;
    }

    .sobre-conteudo {
        .tags-container {
            padding : 0;
            width : 100%;
            display : flex;
            flex-direction : row;
            align-items : center;

            span {
                text-transform : capitalize;
                display : inline-flex;
                border-radius : 15px;
                background-color : #e5e5e5;
                margin-right : 3px;
                padding : 3px 7px;
                line-height : 18px;
                margin-bottom : 3px;
                color : #666;
                font-size : .8em;
            }
        }

        .conteudo {
            font-size : 14px;
            .descricao-objeto {
                text-align: justify;
                margin-bottom: 20px;
                margin-top: 20px;
            }
            .autoria {
                margin-bottom : 30px;
            }

            p {
                margin : 0 0 10px;
            }
        }
    }

    .meta-objeto {
        width: 100%;
        display: inline-block;
        margin-bottom: 15px;
        font-size : 14px;

        .MuiSvgIcon-root {
            vertical-align : middle
        }

        span {
            margin-left : 2%;
            font-weight : 700;
        }

        .license-link {
            text-align : center;
            display : inline-grid;

            a {
                text-decoration : none !important;
                color : initial;

                img {
                    vertical-align : middle;
                    width : auto !important;
                    height : auto !important;
                    float : inherit !important;
                }
            }

            p {
                margin : 0 0 10px;
            }
        }
    }
`

const MetasObjeto = styled.div`
    margin : 20px 0;
    border-left : 1px solid #e5e5e5;
    -webkit-box-orient : vertical;
    -webkit-box-direction : normal;
    -ms-flex-direction : column;
    flex-direction : column;
    -webkit-box-pack : start;
    -ms-flex-pack : start;
    justify-content : flex-start;
    padding : 20px;
    text-align : center;

    .span-st {
        position : relative;
        font-size : 14px;
        color: #666;
    }

    .enviado-por {
        font-size : 14px;
        color :#666;
        font-weight : 500;
        margin-bottom : 5px;
        margin-top : 20px;
        text-align : center;
    }

    .foto-autor {
        display : -webkit-box;
        display : -ms-flexbox;
        display : flex;
        -webkit-box-pack : center;
        -ms-flex-pack : center;
        justify-content : center;
        -webkit-box-align : center;
        -ms-flex-align : center;
        align-items : center;
        padding-top : 10px;

        img {
            width : 60px;
            height : 60px;
            border-radius : 50%;
            vertical-align : middle;
        }
    }

    .nome-autor {
        text-align : center;
        font-weight : 500;
    }
`
