/*Copyright (C) 2019 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana

This file is part of Plataforma Integrada MEC.

Plataforma Integrada MEC is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Plataforma Integrada MEC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with Plataforma Integrada MEC.  If not, see <http://www.gnu.org/licenses/>.*/

import React, {useEffect, useState, useContext} from 'react'
import {Store} from '../../Store.js'
import styled from 'styled-components'
import Firulas from '../Firulas.js'
import Grid from '@material-ui/core/Grid';
import VisibilityIcon from '@material-ui/icons/Visibility';
import GetAppIcon from '@material-ui/icons/GetApp';
import EditIcon from '@material-ui/icons/Edit';
import DeleteForeverIcon from '@material-ui/icons/DeleteForever';
import Button from '@material-ui/core/Button';

export default function TextoObjeto (props) {
    const {state} = useContext(Store)

    const [outrasTematicas, setOutrasTem] = useState('')
    const [componentesCurriculares, setCompCurr] = useState('')
    const [eduStages, setEduStages] = useState('')

    const extractComponentesCurriculares = (subjects) => {
        let outrasTem = []
        let compCurr = []

        subjects.map((subject) => {
            if (!subject.theme) {
                compCurr.push(subject.name)
            }
            else {
                outrasTem.push(subject.name)
            }
        })
        return [outrasTem.join(' - '), compCurr.join(' - ')]
    }

    const extractEduStages = (stages) => {
        return(stages.map((stage) => {return (stage.name)}).join(' - '))
    }

    useEffect(() => {
        let evaluate = extractComponentesCurriculares(props.subjects)
        setOutrasTem(evaluate[0])
        setCompCurr(evaluate[1])

        setEduStages(extractEduStages(props.educationalStages))
    }, [])

    const infos = [
        {label : 'Tipo de Recurso: ', text : props.objType},
        {label : 'Componentes Curriculares: ', text : componentesCurriculares},
        {label : 'Outras Temáticas: ', text : outrasTematicas},
        {label : 'Etapas de Ensino: ', text : eduStages}
    ]

    return (
        <TextoObjetoDiv>
            <Grid container style={{paddingLeft : "15px"}}>
                <Grid item xs={11}>
                    <h3>{props.name}</h3>
                    <Firulas
                        rating={props.rating}
                        likesCount={props.likesCount}
                        liked={props.likedBool}
                    />

                    {
                        infos.map( (info) =>
                            <span className={"info-recurso"}>
                                <span className={"info-cabecalho-recurso"}>{info.label}</span>
                                <span className={"dado-recurso"}>{info.text}</span>
                            </span>
                        )
                    }

                    <span className={"views-downloads"}>
                        <span className={"info-cabecalho-recurso"}>
                            <VisibilityIcon className={"icon"}/>Visualizações:
                        </span>&nbsp;
                        <span className={"dado-recurso"} style={{paddingRight : "50px"}}>{props.viewCount}</span>

                        <span className={"info-cabecalho-recurso"}>
                            <GetAppIcon className={"icon"}/>Baixados/Acessados:
                        </span>&nbsp;
                        <span className={"dado-recurso"}>{props.downloadCount}</span>
                    </span>

                </Grid>
                <Grid item xs={1}>
                    {/*|| checkUserRole('publisher')*/}
                    {(props.id === state.currentUser.id && (props.stateRecurso === 'draft' )) &&
                        <React.Fragment>
                            <Button style={{color : "#666"}}><EditIcon/></Button>
                            <Button style={{color : "#666"}}><DeleteForeverIcon/></Button>
                        </React.Fragment>
                    }

                </Grid>
            </Grid>
        </TextoObjetoDiv>
    )
}

const TextoObjetoDiv = styled.div`
    padding : 20px 20px 0 20px;
    display : flex;
    flex-direction : column;
    justify-content : flex-start;
    flex-wrap : no-wrap;
    align-content : center;
    align-items : flex-start;

    h3 {
        font-size : 26px;
        font-weight : 400;
        margin : 0;
        padding-bottom : 15px;
    }

    .info-recurso {
        display : inline-block;
        width : 100%;
        font-size : 15px;
        font-weight : lighter;
        margin-bottom : 12px;
    }

    .info-cabecalho-recurso {
        font-size : 15px;
    }

    .dado-recurso {
        font-size : 15px;
        font-weight : 600;
    }

    .views-downloads {
        font-size : 15px;
        font-weight : lighter;
        margin-bottom : 12px;
    }

    .icon {
        color : #666;
        vertical-align : middle;
        margin-right : 2px;
    }
`
