/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR
   
This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/


const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const conn = require(`${libs}/db/monet`);

const SqlString = require('sqlstring'); 

 // Promise that executes an SQL query with optional parameters
 // ```
 // Examples:
 //   Query with no parameters:
 //     execSqlQuery('SELECT * FROM people');
 //   Query with one parameter:
 //     execSqlQuery('SELECT name, age FROM people WHERE id = ?', [1]);
 //   Query with more than one parameter:
 //     execSqlQuery('SELECT name, age FROM people WHERE city = ? AND age > ?', ['São Paulo', 35]);
 // ```
function execSqlQuery(sqlQuery, sqlQueryParams = []) {
    log.debug(`Executing SQL query '${sqlQuery}' with params '${sqlQueryParams}'`);
    let queryStrWithParams = SqlString.format(sqlQuery, sqlQueryParams);
    return new Promise((resolve, reject) => {
        // Execute query
        conn.query(queryStrWithParams, [], true).then((dbResult) => {
            // release resources allocated for the prepared statement
            resolve(dbResult.data);
        },(queryError) => {
            log.error(`SQL query execution error: ${queryError.message}`);
            log.error(`SQL query: ${sqlQuery} with params: ${sqlQueryParams}`);
            reject(new Error(queryError.message));
        });
    });
}

function execMultiQuery(querySet = []) {
    // Issue all queries concurrently to the database, for every query object in the iterable
    // NOTE: Array.map() returns a copy of the original array with each object 'mapped'.
    return querySet.map((qry) => { return execSqlQuery(qry.toString()); });
}

module.exports = {execSqlQuery, execMultiQuery};
