/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const ageRangePopSchool = require("../convert/ageRangePopSchool");

const libs = `${process.cwd()}/libs`;
const gender = require(`${libs}/convert/gender`);
const period = require(`${libs}/convert/period`);
const schoolYear = require(`${libs}/convert/schoolYear`);
const admDependency = require(`${libs}/convert/admDependency`);
const admDependencyPriv = require(`${libs}/convert/admDependencyPriv`);
const location = require(`${libs}/convert/location`);
const ruralLocation = require(`${libs}/convert/ruralLocation`);
const ethnicGroup = require(`${libs}/convert/ethnicGroup`);
const ethnicGroupIES = require(`${libs}/convert/ethnicGroupIES`);
const agreement = require(`${libs}/convert/agreement`);
const booleanVariable = require(`${libs}/convert/booleanVariable`);
const educationLevel = require(`${libs}/convert/educationLevel`);
const educationLevelMod = require(`${libs}/convert/educationLevelMod`);
const educationLevelModAgg = require(`${libs}/convert/educationLevelModAgg`);
const educationLevelShort = require(`${libs}/convert/educationLevelShort`);
const educationType = require(`${libs}/convert/educationType`);
const citySize = require(`${libs}/convert/citySize`);
const incomeLevel = require(`${libs}/convert/incomeLevel`);
const idhmLevel = require(`${libs}/convert/idhmLevel`);
const stateName = require(`${libs}/convert/stateName`);
const contractType = require(`${libs}/convert/contractType`);
const ethnicGroupPnad = require(`${libs}/convert/ethnicGroupPnad`);
const ageRange = require(`${libs}/convert/ageRange`);
const ageRangeAll = require(`${libs}/convert/ageRangeAll`);
const ageStudentCode = require(`${libs}/convert/ageStudentCode`);
const fullAgeRange = require(`${libs}/convert/fullAgeRange`);
const genderPnad = require(`${libs}/convert/genderPnad`);
const fifthHouseholdIncome = require(`${libs}/convert/fifthHouseholdIncome`);
const extremesHouseholdIncome = require(`${libs}/convert/extremesHouseholdIncome`);
const educationLevelBasic = require(`${libs}/convert/educationLevelBasic`);
const useTransport = require(`${libs}/convert/booleanVariable`);
const transport = require(`${libs}/convert/transport`);
const useTransportPublic = require(`${libs}/convert/booleanVariable`);
const transportationManager = require(`${libs}/convert/transportationManager`);
const specialClass = require(`${libs}/convert/booleanVariable`);
const integralTime = require(`${libs}/convert/integralTime`);
const educationLevelSchoolYear = require(`${libs}/convert/educationLevelSchoolYear`);
const pfe = require(`${libs}/convert/pfe`);
const upperAdmDependency = require(`${libs}/convert/upperAdmDependency`);
const academicOrganization = require(`${libs}/convert/academicOrganization`);
const ocdeSpecific = require(`${libs}/convert/ocdeSpecific`);
const ocdeGeral = require(`${libs}/convert/ocdeGeral`);
const ocdeDetailed = require(`${libs}/convert/ocdeDetailed`);
const cineSpecific = require(`${libs}/convert/cineSpecific`);
const cineGeral = require(`${libs}/convert/cineGeral`);
const cineDetailed = require(`${libs}/convert/cineDetailed`);
const academicLevel = require(`${libs}/convert/academicLevel`);
const upperEducationMod = require(`${libs}/convert/upperEducationMod`);
const studentDeficiency = require(`${libs}/convert/studentDeficiency`);
const schoolType = require(`${libs}/convert/schoolType`);
const upperTurn = require(`${libs}/convert/upperTurn`);
const teacherSituation = require(`${libs}/convert/teacherSituation`);
const workRegime = require(`${libs}/convert/workRegime`);
const substitute = require(`${libs}/convert/booleanVariable`);
const visitor = require(`${libs}/convert/booleanVariable`);
const eadTeacher = require(`${libs}/convert/booleanVariable`);
const graduationPresential = require(`${libs}/convert/booleanVariable`);
const postgraduateEadTeacher = require(`${libs}/convert/booleanVariable`);
const postgraduatePresentialTeacher = require(`${libs}/convert/booleanVariable`);
const teacherSchooling = require(`${libs}/convert/teacherSchooling`);
const ethnicGroupTeacherIES = require(`${libs}/convert/ethnicGroupTeacherIES`);
const genderIES = require(`${libs}/convert/genderIES`);
const deficiency = require(`${libs}/convert/studentDeficiency`);
const governmentAgreement = require(`${libs}/convert/governmentAgreement`);
const arrangement = require(`${libs}/convert/arrangement`);
const nightTime = require(`${libs}/convert/nightTime`);
const discipline = require(`${libs}/convert/discipline`);
const finishUniversity = require(`${libs}/convert/finishUniversity`);
const initialTraining = require(`${libs}/convert/initialTraining`);
const posTraining = require(`${libs}/convert/posTraining`);
const licentiateDegree = require(`${libs}/convert/licentiateDegree`);
const enrolledVacanciesFreshmen = require(`${libs}/convert/enrolledVacanciesFreshmen`);
const enterSituation = require(`${libs}/convert/enterSituation`);
const enrollmentSituation = require(`${libs}/convert/enrollmentSituation`);
const diffLocation = require(`${libs}/convert/diffLocation`);
const peePorCategoria = require(`${libs}/convert/peePorCategoria`);
const pee = require(`${libs}/convert/booleanVariable`);
const shift = require(`${libs}/convert/shift`);
const admDependencyPub = require(`${libs}/convert/admDependencyPub`);
const supplyDimension = require(`${libs}/convert/supplyDimension`);
const type = require(`${libs}/convert/type`);
const level = require(`${libs}/convert/level`);
const scholarDependency = require(`${libs}/convert/scholarDependency`);
const newPnadAdmDependency = require(`${libs}/convert/newPnadAdmDependency`);
const illiteracy = require(`${libs}/convert/illiteracy`);
const yearsOfStudy = require(`${libs}/convert/yearsOfStudy`);
const instructionLevel = require(`${libs}/convert/instructionLevel`);
const attendsSchool = require(`${libs}/convert/attendsSchool`);
const modality = require(`${libs}/convert/modality`);
const attendedModality = require(`${libs}/convert/attendedModality`);
const ethnicGroupNewPnad = require(`${libs}/convert/ethnicGroupNewPnad`);
const capitalCode = require(`${libs}/convert/capitalCode`);
const regionCode = require(`${libs}/convert/regionCode`);
const metroCode =  require(`${libs}/convert/metroCode`);
const modalityShift = require(`${libs}/convert/modalityShift`);
const incomeRange = require(`${libs}/convert/incomeRange`);
const ageRangeAggregate = require(`${libs}/convert/ageRangeAggregate`);
const specialEducation = require(`${libs}/convert/specialEducation`);
const specialEducationDoc = require(`${libs}/convert/specialEducationDoc`);
const specialEducationEntity = require(`${libs}/convert/specialEducationEntity`);
const educationLevelModDoc = require(`${libs}/convert/educationLevelModDoc`);
const educationLevelModEntitySeg = require(`${libs}/convert/educationLevelModEntitySeg`);
const educationLevelModEntityAgg = require(`${libs}/convert/educationLevelModEntityAgg`);
const ageRangeEntity = require(`${libs}/convert/ageRangeEntity`);
const postGraduationEntity = require(`${libs}/convert/postGraduationEntity`);
const totalDoc = require(`${libs}/convert/totalDoc`);
const educationDegreeEntity = require(`${libs}/convert/educationDegreeEntity`);
const expenses = require(`${libs}/convert/expenses.js`)
const potentialRevenue = require(`${libs}/convert/potentialRevenue.js`)
const revenue = require(`${libs}/convert/revenue`);
const studentCost = require(`${libs}/convert/studentCost`);
const ageRangeOutSchool = require(`${libs}/convert/ageRangePopSchool`);
const ageRange19to64 = require(`${libs}/convert/ageRange19to64`);

const ids = {
    gender_id: gender,
    period_id: period,
    school_year_id: schoolYear,
    education_level_id: educationLevel,
    education_level_basic_id: educationLevelBasic,
    education_level_mod_id: educationLevelMod,
    education_level_mod_agg_id: educationLevelModAgg,
    education_level_short_id: educationLevelShort,
    adm_dependency_id: admDependency,
    adm_dependency_detailed_id: admDependencyPriv,
    adm_dependency_public_id: admDependencyPub,
    location_id: location,
    rural_location_id: ruralLocation,
    location_detailed_id: ruralLocation,
    ethnic_group_id: ethnicGroup,
    agreement_id: agreement,
    integral_time_id: integralTime,
    government_agreement_id: governmentAgreement,
    education_day_care_child_id: booleanVariable,
    education_preschool_child_id: booleanVariable,
    education_begin_elementary_school_id: booleanVariable,
    education_end_elementary_school_id: booleanVariable,
    education_middle_school_id: booleanVariable,
    education_professional_id: booleanVariable,
    education_eja_id: booleanVariable,
    education_type_id: educationType,
    income_level_id: incomeLevel,
    city_size_id: citySize,
    idhm_level_id: idhmLevel,
    state_id: stateName,
    contract_type_id: contractType,
    ethnic_group_pnad_id: ethnicGroupPnad,
    age_range_id: ageRange,
    age_range_all_id: ageRangeAll,
    age_range_aggregate_id: ageRangeAggregate,
    full_age_range_id: fullAgeRange,
    gender_pnad_id: genderPnad,
    fifth_household_income_id: fifthHouseholdIncome,
    extremes_household_income_id: extremesHouseholdIncome,
    use_transport_id: useTransport,
    use_transport_public_id: useTransportPublic,
    transportation_manager_id: transportationManager,
    special_class_id: specialClass,
    education_level_school_year_id: educationLevelSchoolYear,
    pfe_id: pfe,
    upper_adm_dependency_id: upperAdmDependency,
    academic_organization_id: academicOrganization,
    ocde_specific_id: ocdeSpecific,
    ocde_geral_id: ocdeGeral,
    ocde_detailed_id: ocdeDetailed,
    cine_specific_id: cineSpecific,
    cine_geral_id: cineGeral,
    cine_detailed_id: cineDetailed,
    academic_level_id: academicLevel,
    upper_education_mod_id: upperEducationMod,
    student_deficiency_id: studentDeficiency,
    school_type_id: schoolType,
    upper_turn_id: upperTurn,
    is_free_id: booleanVariable,
    night_time_id: nightTime,
    capital_id: booleanVariable,
    ethnic_group_ies_id: ethnicGroupIES,
    teacher_situation_id: teacherSituation,
    work_regime_id: workRegime,
    substitute_id: booleanVariable,
    visitor_id: booleanVariable,
    ead_teacher_id: eadTeacher,
    graduation_presential_id: graduationPresential,
    postgraduate_ead_teacher_id: postgraduateEadTeacher,
    postgraduate_presential_teacher_id: postgraduatePresentialTeacher,
    teacher_schooling_id: teacherSchooling,
    ethnic_group_teacher_ies_id: ethnicGroupTeacherIES,
    gender_ies_id: genderIES,
    deficiency_id: deficiency,
    age_student_code_id: ageStudentCode,
    transport_id: transport,
    arrangement_id: arrangement,
    discipline: discipline,
    finish_id: finishUniversity,
    initial_training_id: initialTraining,
    pos_training_id: posTraining,
    licentiate_degree_id: licentiateDegree,
    enrolled_vacancies_freshmen: enrolledVacanciesFreshmen,
    enter_situation: enterSituation,
    enrollment_situation: enrollmentSituation,
    diff_location_id: diffLocation,
    pee_por_categoria: peePorCategoria,
    pee_id: pee,
    shift_id: shift,
    supply_dimension_id: supplyDimension,
    type_id: type,
    level_id: level,
    scholar_dependency_id: scholarDependency,
    new_pnad_adm_dependency_id: newPnadAdmDependency,
    illiteracy_id: illiteracy,
    years_of_study_id: yearsOfStudy,
    instruction_level_id: instructionLevel,
    attends_school_id: attendsSchool,
    modality_id: modality,
    attended_modality_id: attendedModality,
    bolsa_familia_id: attendsSchool,
    new_pnad_ethnic_group_id: ethnicGroupNewPnad,
    cap_code_id: capitalCode,
    region_id: regionCode,
    metro_code_id: metroCode,
    modality_shift_id: modalityShift,
    income_range_id: incomeRange,
    special_education: specialEducation,
    special_education_doc: specialEducationDoc,
    education_level_mod_doc: educationLevelModDoc,
    education_level_mod_entity_seg: educationLevelModEntitySeg,
    education_level_mod_entity_agg: educationLevelModEntityAgg,
    age_range_entity: ageRangeEntity,
    post_graduation_entity: postGraduationEntity,
    special_education_entity: specialEducationEntity,
    total_doc: totalDoc,
    education_degree_entity: educationDegreeEntity,
    despesas_id: expenses,
    receita_potencial_id: potentialRevenue,
    receitas_id: revenue,
    student_cost: studentCost,
    age_range_pop_school_id: ageRangePopSchool,
    age_range_19_to_64_id: ageRange19to64
};

function transform(removeId=false) {
    return (req, res, next) => {
        if(req.result.length <= 0) {
            return next();
        }
        // Para cada objeto do resultado
        req.result.forEach((obj) => {
            //console.log(obj),
            Object.keys(obj).forEach((key) => {
                // Se não há uma função especificada, retorna
                if(typeof ids[key] === 'undefined') return;
                let id = obj[key];
                obj[key.replace('_id', '_name')] = ids[key](id);
                if(removeId) delete obj[key];
            });
        });
        next();
    };
}

function multitransform(removeId=false) {
    return (req, res, next) => {
        Object.keys(req.result[0]).forEach((query) => {
            req.result[0][query].forEach((obj) => {
                Object.keys(obj).forEach((key) => {
                    if(typeof ids[key] === 'undefined') return;
                    let id = obj[key];
                    obj[key.replace('_id', '_name')] = ids[key](id);
                    if(removeId) delete obj[key];
                });
            })
        });
        next();
    }
}

module.exports = {
    transform,
    multitransform,
    gender,
    period,
    schoolYear,
    educationLevel,
    educationLevelBasic,
    educationLevelMod,
    educationLevelModAgg,
    educationLevelShort,
    educationLevelSchoolYear,
    admDependency,
    admDependencyPriv,
    location,
    ruralLocation,
    ethnicGroup,
    agreement,
    booleanVariable,
    educationType,
    incomeLevel,
    citySize,
    idhmLevel,
    stateName,
    contractType,
    ethnicGroupPnad,
    ageRange,
    ageRangeAggregate,
    ageRangeAll,
    ageStudentCode,
    fullAgeRange,
    genderPnad,
    fifthHouseholdIncome,
    extremesHouseholdIncome,
    useTransport,
    transportationManager,
    specialClass,
    integralTime,
    upperAdmDependency,
    academicOrganization,
    ocdeSpecific,
    ocdeGeral,
    ocdeDetailed,
    cineSpecific,
    cineGeral,
    cineDetailed,
    academicLevel,
    upperEducationMod,
    studentDeficiency,
    schoolType,
    ethnicGroupIES,
    upperTurn,
    teacherSituation,
    workRegime,
    substitute,
    visitor,
    eadTeacher,
    graduationPresential,
    postgraduateEadTeacher,
    postgraduatePresentialTeacher,
    teacherSchooling,
    ethnicGroupTeacherIES,
    genderIES,
    deficiency,
    transport,
    governmentAgreement,
    arrangement,
    nightTime,
    discipline,
    finishUniversity,
    initialTraining,
    posTraining,
    licentiateDegree,
    enrolledVacanciesFreshmen,
    enterSituation,
    enrollmentSituation,
    diffLocation,
    peePorCategoria,
    pee,
    shift,
    admDependencyPub,
    newPnadAdmDependency,
    illiteracy,
    yearsOfStudy,
    instructionLevel,
    attendsSchool,
    modality,
    attendedModality,
    ethnicGroupNewPnad,
    capitalCode,
    regionCode,
    metroCode,
    modalityShift,
    incomeRange,
    specialEducation,
    specialEducationDoc,
    educationLevelModDoc,
    educationLevelModEntitySeg,
    educationLevelModEntityAgg,
    ageRangeEntity,
    postGraduationEntity,
    specialEducationEntity,
    totalDoc,
    educationDegreeEntity,
    expenses,
    potentialRevenue,
    revenue,
    studentCost,
    ageRangePopSchool,
    ageRange19to64
};
