const libs = `${process.cwd()}/libs`;
const log = require(`${libs}/log`)(module);
const db = require(`${libs}/db/query_exec`);

// Middleware that executes multiples queries 
function multiQuery(req, res, next) {
    Promise.all(db.execMultiQuery(req.querySet)).then((queryResults) => {
        req.result = queryResults;
        next();
    }).catch((err) => {
        log.error(`[SQL query error] ${err}`);
        next(err);
    });
}

module.exports = multiQuery;
