/*
Middleware que remove o campo "region" quando o campo "city" está ativo nos filtros.
Devido à limitações na tabela de dados, quando ambos campos estão ativos o filtro por
"região" funciona incorretamente. 
*/
module.exports = function potentialRevenueParser(req, res, next) {
    if (req.query && req.query.filter) {
        const jsonString = `{${req.query.filter.replace(/(\w+):/g, '"$1":')}}`;
        const obj = JSON.parse(jsonString);

        if ("city" in obj && "region" in obj) {
            delete obj.region;
            const customString = Object.entries(obj)
                .map(([key, value]) => `${key}:"${value}"`)
                .join(',');
            req.query.filter = customString;
        }
    }

    next();
};
