const libs = `${process.cwd()}/libs`;
const log = require(`${libs}/log`)(module);
const db = require(`${libs}/db/query_exec`);

 // Middleware that executes a query defined by a squel object in req.sql
function query(req, res, next) {
    let sql = req.sql.toParam();
    log.info(`Executando query ${req.sql.toString()}`);
    sql.text = sql.text.replace(/`/g, "");
    execute(sql.text, sql.values, (err, result) => {
        if(err) {
            log.error(err.stack);
            console.log(sql.text);
            console.log(sql.values);
            next(new Error('Request could not be satisfied due to a database error.'));
        } else {
            req.result = result;
            next();
        }
    });
}

function execute(text, values, cb) {
    db.execSqlQuery(text, values).then((result) => {
        cb(null, result);
    }, (error) => {
        log.error(error.stack);
        cb(new Error('Request could not be satisfied due to a database error.'));
    });
}

module.exports = {query, execute};
