class ReqBody {
    constructor() {

    }

    add_metrics(req, column, metricsArray) {
        for (let i in metricsArray) {
            switch(metricsArray[i]["function"]) {
                case "max":
                    req.sql.field("max(" + column + ")", metricsArray[i]["return_name"]);
                    req.hasMetrics = true;
                    break;
                case "min":
                    req.sql.field("min(" + column + ")", metricsArray[i]["return_name"]);
                    req.hasMetrics = true;
                    break;
                case "count":
                    req.sql.field("count(" + column + ")", metricsArray[i]["return_name"]);
                    req.hasMetrics = true;
                    break;
                case "sum":
                    req.sql.field("sum(" + column + ")", metricsArray[i]["return_name"]);
                    req.hasMetrics = true;
                    break;
                default:
                    break;
            }
        }
    }

    parse() {
        return(req, res, next) => {
            // Gets body of the HTTP requisition
            let body = req.body;

            // Chooses operation based on the mode field of the body
            switch(body["mode"]) {
                case "add_metrics":
                    // adds flag to check whether it runs the default query or not
                    req.hasMetrics = false;
                    // Gets all column names
                    let columns = Object.keys(body["add_metrics"]);
                    // Calls function to add metrics that were specified to req.sql
                    for (let i in columns) {
                        this.add_metrics(req, columns[i], body["add_metrics"][columns[i]]);
                    }

                    break;

                default:
                    break;
            }

            next();
        }
    }
}

module.exports = ReqBody;