const libs = `${process.cwd()}/libs`;
const log = require(`${libs}/log`)(module);
const xml = require('js2xmlparser');
const csv = require('csv-express');

// Função para transformar um resultado que contém objetos com arrays aninhados em vários objetos
//      sem arrays aninhandos
function flatObj(obj) {
    let flatList = [];
    let tempObj = {};

    Object.keys(obj).forEach((key) => {
        if(obj[key] instanceof Array) {
            obj[key].forEach((i) => {
                let flatten = flatObj(i);
                if(flatten instanceof Array) {
                    flatten.forEach((j) => {
                        flatList.push(Object.assign({}, tempObj, j));
                    });
                } else {
                    flatList.push(Object.assign({}, tempObj, flatten));
                }
            });
        } else if(obj[key] instanceof Object) {
            tempObj = Object.assign({}, tempObj, obj[key]);
        } else {
            tempObj[key] = obj[key];
        }
    });

    if(flatList.length > 0) return flatList;
    return tempObj;
}

 // Custom generic middleware used to answer requests.
 // The function reads the req.query.format param and answers in json, xml or csv
function response(value) {
    return (req, res, next) => {
        if (req.query.format === 'csv') {
            let result = [];
            req.result.forEach((i) => {
                let flatten = flatObj(i);
                if(flatten instanceof Array) {
                    result = [...result, ...flatten];
                } else {
                    result.push(flatten);
                }
            });
            res.attachment(`${value}.csv`);
            res.csv(result, true);
        } else if (req.query.format === 'xml') {
            res.send(xml.parse('result', { [value]: req.result }));
        } else {
            res.json({ result: req.result });
        }
    };
}

module.exports = response;
