const Sequelize = require("sequelize");
const db = require('../db/postgres.js')
const libs = `${process.cwd()}/libs`;
const User = require(`${libs}/models/user`);
const Client = require(`${libs}/models/client`);

var AccessToken = db.define("AccessToken",{
    user_id: {
        type: Sequelize.STRING,
        allowNull: false
    },
    client_id:{
        type: Sequelize.STRING,
        allowNull: false
    },
    token:{
        type: Sequelize.STRING, 
        allowNull: false,
        unique: true,
        primaryKey: true
    },
    created_at:{
        type: Sequelize.DATE,
        defaultValue: Date.now
    }},
    {timestamps: false}
);

AccessToken.hasOne(User, { foreignKey: 'id' });
AccessToken.hasOne(Client, { foreignKey: 'id' });

module.exports = AccessToken;
