const Sequelize = require("sequelize");
const crypto = require('crypto');
const db = require('../db/postgres.js');
const libs = `${process.cwd()}/libs`;
const User = require(`${libs}/models/user`);

var Download = db.define("Download",{
    id:{
        type: Sequelize.INTEGER, 
        allowNull: false,
        autoIncrement: true,
        unique: true,
        primaryKey: true
    },
    user_id: {
        type: Sequelize.STRING,
        allowNull: false
    },
    table:{
        type: Sequelize.STRING, 
        allowNull: false,
    },
    name:{
        type: Sequelize.STRING,
        allowNull: false,
    },
    mapping_table:{
        type: Sequelize.STRING,
        allowNull:false
    },
    query: {
        type: Sequelize.STRING,
        allowNull:false
    },
    created_at:{
        type: Sequelize.DATE,
        defaultValue: Date.now
    }, 
    updated_at: {
        type: Sequelize.DATE,
        defaultValue: Date.now
    },
    status: {
        type: Sequelize.STRING
    },
    size: {
        type: Sequelize.NUMBER
    },
    expired: {
        type: Sequelize.BOOLEAN
    },
    link: {
        type: Sequelize.STRING,
    }},
    {timestamps: false}
);

Download.hasOne(User,{ foreignKey: 'id' });

module.exports = Download
