
const Sequelize = require("sequelize");
const db = require('../db/postgres.js');
const libs = `${process.cwd()}/libs`;

var File = db.define("File",{
    id: {
        type: Sequelize.STRING,
        allowNull:false,
        unique: true,
        primaryKey: true
    },
    type:{
        type: Sequelize.STRING
    },
    name: {
        type: Sequelize.STRING
    },
    data: {
        type: Sequelize.BLOB('long')
    }
},
{timestamps: false});

File.generateObjectId = function(){
    var timestamp = (new Date().getTime() / 1000 | 0).toString(16);
    return timestamp + 'xxxxxxxxxxxxxxxx'.replace(/[x]/g, function() {
        return (Math.random() * 16 | 0).toString(16);
    }).toLowerCase();
}

const setObjectId = file => {
   file.id = File.generateObjectId()
};

File.beforeCreate(setObjectId);

module.exports=File;
	
