const Sequelize = require("sequelize");
const db = require('../db/postgres.js');
const libs = `${process.cwd()}/libs`;
const Role = require(`${libs}/models/role`);

var Permission = db.define("PermissionRole",{
    id:{
        type: Sequelize.STRING,
        allowNull:false,
        unique: true,
        primaryKey: true
    },
    permission_name:{
        type: Sequelize.STRING,
        allowNull:false,
    },
    permission_description:{
        type: Sequelize.STRING,
        allowNull:false
    }
},
{timestamps: false});

Permission.generateObjectId = function(){
    var timestamp = (new Date().getTime() / 1000 | 0).toString(16);
    return timestamp + 'xxxxxxxxxxxxxxxx'.replace(/[x]/g, function() {
        return (Math.random() * 16 | 0).toString(16);
    }).toLowerCase();
}

const setObjectId = permission => {
   permission.id = Permission.generateObjectId()
};

Permission.beforeCreate(setObjectId);


module.exports = Permission;

