const Sequelize = require("sequelize");
const db = require('../db/postgres.js');
const libs = `${process.cwd()}/libs`;
const Role = require(`${libs}/models/role`);
const Permission = require(`${libs}/models/permission`);

var PermissionRole = db.define("PermissionRole",{
    id:{
        type: Sequelize.INTEGER,
        allowNull:false,
        unique: true,
        primaryKey: true
    },
    role_id:{
        type: Sequelize.INTEGER,
        allowNull:false,
    },
    permission_id:{
        type: Sequelize.INTEGER,
        allowNull:false
    }
},
{timestamps: false});

PermissionRole.hasMany(Role, {foreignKey: 'id'});
PermissionRole.hasMany(Permission, {foreignKey: 'id'});

module.exports = PermissionRole;

