const Sequelize = require("sequelize");
const db = require('../db/postgres.js');
const libs = `${process.cwd()}/libs`;
const User = require(`${libs}/models/user`);
const Activity = require(`${libs}/models/activity`);

var userActivity = db.define("userActivity",{
    id:{
        type: Sequelize.INTEGER,
        allowNull:false,
        unique: true,
        primaryKey: true
    },
    user_id:{
        type: Sequelize.STRING,
        allowNull:false,
    },
    activity_id:{
        type: Sequelize.STRING,
        allowNull:false
    }
},
{timestamps: false});

userActivity.hasMany(User, {foreignKey: 'id'});
userActivity.hasMany(Activity, {foreignKey: 'id'});

module.exports = userActivity;

