const Sequelize = require("sequelize");
const db = require('../db/postgres.js');
const libs = `${process.cwd()}/libs`;
const User = require(`${libs}/models/user`);
const Publication = require(`${libs}/models/publication`);

var userPublication = db.define("userPublication",{
    id:{
        type: Sequelize.INTEGER,
        allowNull:false,
        unique: true,
        primaryKey: true
    },
    user_id:{
        type: Sequelize.STRING,
        allowNull:false,
    },
    publication_id:{
        type: Sequelize.STRING,
        allowNull:false
    }
},
{timestamps: false});

userPublication.hasMany(User, {foreignKey: 'id'});
userPublication.hasMany(Publication, {foreignKey: 'id'});

module.exports = userPublication;

