const Sequelize = require("sequelize");
const db = require('../db/postgres.js')
const User = require(`./user.js`);
const uuid = require('node-uuid');

var VerificationToken = db.define("VerificationToken",{
    user_id: {
        type: Sequelize.STRING, 
        allowNull: false
    },
    token:{
        type: Sequelize.STRING,
        allowNull: false,
        primaryKey: true
    },
    verified:{
        type: Sequelize.BOOLEAN,
        allowNull: false,
        defaultValue: false
    },
    created_at:{
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Date.now
    }
},
{timestamps: false});

VerificationToken.hasOne(User,{ foreignKey: 'id' });

module.exports = VerificationToken;
