const express = require('express');

const cubApp = express.Router();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const id2str = require(`${libs}/middlewares/id2str`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const request = require(`request`);

const config = require(`${libs}/config`);

const passport = require('passport');

const download = require(`${libs}/middlewares/downloadDatabase`);

const addMissing = require(`${libs}/middlewares/addMissing`);

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();
let rqfCount = new ReqQueryFields();

cubApp.get('/year_range', (req, res, next) => {
    req.sql.from('cub')
    .field('MIN(cub.ano_censo)', 'start_year')
    .field('MAX(cub.ano_censo)', 'end_year');
    next();
}, query, response('range'));

cubApp.get('/years', (req, res, next) => {
    req.sql.from('cub')
    .field('DISTINCT cub.ano_censo', 'year');
    next();
}, query, response('years'));

cubApp.get('/months', (req, res, next) => {
    req.sql.from('cub')
    .field('DISTINCT cub.mes_censo', 'month');
    next();
}, query, response('months'));

cubApp.get('/years_months', (req, res, next) => {
    req.sql.from('cub')
    .field('DISTINCT cub.ano_censo AS "year", cub.mes_censo AS "month"');
    next();
}, query, response('years_months'));

cubApp.get('/price_type', (req, res, next) => {
    req.sql.from('cub')
    .field('DISTINCT cub.tipo_preco', 'price_type');
    next();
}, query, response('price_type'));

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'state',
    table: 'estado',
    tableField: ['sigla', 'id'],
    resultField: ['sigla_uf', 'cod_uf'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'estado_id',
        table: 'cub'
    },
    // join: {
    //     primary: 'id',
    //     foreign: 'estado_id',
    //     foreignTable: 'cub'
    // }
}).addValue({
    name: 'min_year',
    table: 'cub',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '>=',
        type: 'integer',
        table: 'cub',
        field: 'ano_censo'
    }
}).addValue({
    name: 'max_year',
    table: 'cub',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '<=',
        type: 'integer',
        table: 'cub',
        field: 'ano_censo'
    }
}).addValue({
    name: 'min_month',
    table: 'cub',
    tableField: 'mes_censo',
    resultField: 'month',
    where: {
        relation: '>=',
        type: 'integer',
        table: 'cub',
        field: 'mes_censo'
    }
}).addValue({
    name: 'max_month',
    table: 'cub',
    tableField: 'mes_censo',
    resultField: 'month',
    where: {
        relation: '<=',
        type: 'integer',
        table: 'cub',
        field: 'mes_censo'
    }
});

cubApp.get('/last_state_values', rqf.parse(), rqf.build(), (req, res, next) => {

    var price_by_id = squel.select().from('cub')
    .field('estado_id')
    .field('MAX(ano_censo*100 + mes_censo)', 'ano_censo')
    .group('estado_id')

    if (req.filter.size || req.dims.size){
        if ('state' in req.filter || 'state' in req.dims){
            //req.sql = states
            req.sql.from('cub')
            .field('cub.ano_censo', 'ano')
            .field('cub.mes_censo', 'mes')
            .field('cub.tipo_preco', 'tipo_preco')
            .field('cub.preco', 'preco')
            .join(
                price_by_id, 
                'sub', 
                'cub.estado_id = sub.estado_id AND cub.ano_censo = (sub.ano_censo/100)'
            )
            .join('estado', null, 'cub.estado_id = estado.id')
            .group('cub.ano_censo')
            .group('cub.mes_censo')
            .group('cub.tipo_preco')
            .group('cub.preco')
        }
        else{
            req.sql.from("cub")
        }
    }
    else{
        //req.sql = average
        req.sql.from(
            squel.select().from('cub')
            .field('cub.tipo_preco', 'tipo_preco')
            .field('cub.preco', 'preco')
            .join(price_by_id, 'sub', 
                'cub.estado_id = sub.estado_id AND cub.ano_censo = (sub.ano_censo/100)'
            )
            .join('estado', null, 'cub.estado_id = estado.id')
            , "states")
        .field('AVG(states.preco)', 'preco')
        .field("'BR'", 'sigla_uf')
        .field('states.tipo_preco')
        .group('states.tipo_preco')
    }
    next();
}, query, id2str.transform(), response('last_state_values'))

cubApp.get('/', rqf.parse(), rqf.build(), (req, res, next) => {
    if (req.filter.size || req.filter.dims) {
        if ('state' in req.filter || 'state' in req.dims) {
            req.sql.from('cub')
            .field('cub.estado_id', 'cod_uf')
            .field('estado.sigla', 'sigla_uf')
            .field('cub.tipo_preco', 'tipo_preco')
            .field('cub.preco', 'preco')
            .join('estado', null, 'cub.estado_id=estado.id')
            .group('cub.ano_censo')
            .group('cub.mes_censo')
            .group('cub.estado_id')
            .group('estado.sigla')
            .group('cub.tipo_preco')
            .group('cub.preco')
        } else {
            req.sql.from('cub')
            .field("'BR'", 'sigla_uf')
            .field("cub.tipo_preco", 'tipo_preco')
            .field('AVG(cub.preco)', 'preco')
            .join('estado', null, 'cub.estado_id=estado.id')
            .group('cub.ano_censo')
            .group('cub.mes_censo')
            .group('cub.tipo_preco')
        }
    } else {
        req.sql.from('cub')
        .field('cub.estado_id', 'cod_uf')
        .field('estado.sigla', 'sigla_uf')
        .field('cub.tipo_preco', 'tipo_preco')
        .field('cub.preco', 'preco')
        .join('estado', null, 'cub.estado_id=estado.id')
        .group('cub.ano_censo')
        .group('cub.mes_censo')
        .group('cub.estado_id')
        .group('estado.sigla')
        .group('cub.tipo_preco')
        .group('cub.preco')
    }

    next();
}, query, id2str.transform(), response('cub'));

module.exports = cubApp;
